<?php include 'inc/funtions.php';
if (isset($_SESSION['user_type'])) {
    $user_id = $_SESSION['user_id'];
    $business_id = $_SESSION['business_id'];
    $user = getUserId($user_id);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    
    <link rel="stylesheet" href="assets/vendors/chartjs/Chart.min.css">
    <link rel="stylesheet" href="assets/vendors/simple-datatables/style.css">
    <link rel="stylesheet" href="assets/vendors/perfect-scrollbar/perfect-scrollbar.css">
    <link rel="stylesheet" href="assets/css/app.css">
    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
    <script src="assets/vendors/chartjs/chart.umd.min.js"></script>
</head>
<body>
    <div id="app">
        <?php include('inc/header.php'); ?>
    <section class="section dashboard">
      <div class="card-body">
          <!-- Default Tabs -->
          <ul class="nav nav-tabs d-flex" id="myTabjustified" role="tablist">
            <li class="nav-item flex-fill" role="presentation">
              <button class="nav-link w-100 active" id="Profile-tab" data-bs-toggle="tab" data-bs-target="#Profile-justified" type="button" role="tab" aria-controls="Profile" aria-selected="true"> <i class="bi bi-person"></i> Profile</button>
            </li>
            <li class="nav-item flex-fill" role="presentation">
              <button class="nav-link w-100" id="security-tab" data-bs-toggle="tab" data-bs-target="#security-justified" type="button" role="tab" aria-controls="security" aria-selected="false"><i class="bi bi-shield"></i> Security </button>
            </li>
            <li class="nav-item flex-fill" role="presentation">
              <button class="nav-link w-100" id="biometric-tab" data-bs-toggle="tab" data-bs-target="#biometric-justified" type="button" role="tab" aria-controls="biometric" aria-selected="false"> <i class="bi bi-key"></i> Biometric</button>
            </li>
          </ul>
          <div class="tab-content pt-2" id="myTabjustifiedContent">
            <div class="tab-pane fade show active" id="Profile-justified" role="tabpanel" aria-labelledby="Profile-tab">
              <div class="card p-5">
                <div class="card-title">
                  <div class="fs-3">
                    <i class="bi bi-person text-primary"></i>
                  Profile Information
                </div>
                <div class="text-muted" style="font-size: 12px;">Update your personal information and preferences</div>
                </div>
                <div class="card-body">
                  <div class="align-items-center justify-content-center">
                    <div class="text-center mb-3">
                      <div class="mt-auto pt-4">
                        <div class="align-items-center">
                            <img id="profilePreview" src="assets/images/avatar/<?php echo $user['profile_img']; ?>" class="rounded-circle me-2 mb-3" style="width: 250px; height: 250px; object-fit: cover; border: 2px solid #0d6efd;">
                            <div>
                                <input type="hidden" id="pre_profile" value="<?php echo $user['profile_img']; ?>">
                                <label for="userProfilePicInput" class="btn btn-primary">
                                    Change Photo
                                </label>
                                <input type="file" id="userProfilePicInput" hidden accept="image/*">
                            </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="row g-3">
                    <div class="form-floating mb-3 col-lg-6">
                      <input class="form-control" id="first_name" placeholder="Enter your full name" value="<?php echo $user['first_name'] ?>">
                      <label for="first_name">First Name</label>
                    </div>
                    <div class="form-floating mb-3 col-lg-6">
                      <input class="form-control" id="last_name" placeholder="Enter your full name" value="<?php echo $user['last_name'] ?>">
                      <label for="last_name">Last Name</label>
                    </div>
                    <div class="form-floating mb-3 col-lg-6">
                      <input class="form-control" id="middle_name" placeholder="Enter your full name" value="<?php echo $user['middle_name'] ?>">
                      <label for="middle_name">Middle Name</label>
                    </div>
                    <div class="form-floating mb-3 col-lg-6">
                      <input class="form-control" id="email" placeholder="Enter your email" type="email" value="<?php echo $user['email'] ?>">
                      <label for="email">Email Address</label>
                    </div>
                    <div class="form-floating mb-3 col-lg-4">
                      <input class="form-control" id="phoneNumber" placeholder="Enter your phone number" type="tel" value="<?php echo $user['phone_no'] ?>">
                      <label for="phoneNumber">Phone Number</label>
                    </div>
                    <div class="form-floating mb-3 col-lg-4">
                      <input class="form-control" id="dateOfBirth" type="date" value="<?php echo $user['dob'] ?>">
                      <label for="dateOfBirth">Date of Birth</label>
                    </div>
                    <div class="form-floating mb-3 col-lg-4">
                      <select class="form-control" id="gender">
                        <option value="" disabled selected>Select your Gender</option>
                        <option value="M" <?php if($user['gender'] == 'M'){echo 'selected';} ?>>Male</option>
                        <option value="F" <?php if($user['gender'] == 'F'){echo 'selected';} ?>>Female</option>
                      </select>
                      <label for="gender">Gender</label>
                    </div>
                  </div>
                  <div class="form-floating mb-3 col-12">
                    <textarea class="form-control" id="address" rows="3"><?php echo $user['address'] ?></textarea>
                    <label for="address">Address</label>
                  </div>
                  <div class="form-floating mb-3 col-12">
                    <textarea class="form-control" id="bio" rows="4"><?php echo $user['bio'] ?></textarea>
                    <label for="bio">Bio</label>
                  </div>
                  <button class="btn btn-outline-primary w-100" id="Update_Profile"> <i class="bi bi-save2"></i> Update Profile</button>
                </div>
              </div>
            </div>
            <div class="tab-pane fade" id="security-justified" role="tabpanel" aria-labelledby="security-tab">
                <div class="card w-100 p-3">
                    <div class="card-title mb-4">
                        <h3 class="fs-5 fw-bold"><i class="bi bi-shield-lock text-danger"></i> Change Password</h3>
                        <p class="text-muted fw-light fs-6">Update your account password to stay secure.</p>
                    </div>
                    <div class="card-body">
                        <form id="changePasswordForm">
                            <input type="hidden" id="security-email" value="<?php echo $user['email']; ?>">
                            
                            <div class="form-floating mb-3">
                                <input type="password" class="form-control" id="current_password" placeholder="Current Password" required>
                                <label for="current_password">Current Password</label>
                            </div>
                            <div class="form-floating mb-3">
                                <input type="password" class="form-control" id="new_password" placeholder="New Password" required minlength="8">
                                <label for="new_password">New Password</label>
                            </div>
                            <div class="form-floating mb-3">
                                <input type="password" class="form-control" id="confirm_new_password" placeholder="Confirm New Password" required>
                                <label for="confirm_new_password">Confirm New Password</label>
                            </div>
                            
                            <button type="button" class="btn btn-danger w-100" id="btnUpdatePass">
                                <i class="bi bi-check-circle"></i> Update Password
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="biometric-justified" role="tabpanel" aria-labelledby="biometric-tab">
              <div class="card">
                <div class="card-body p-4">
                  <div class="fs-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="text-primary"><path d="M12 10a2 2 0 0 0-2 2c0 1.02-.1 2.51-.26 4"></path><path d="M14 13.12c0 2.38 0 6.38-1 8.88"></path><path d="M17.29 21.02c.12-.6.43-2.3.5-3.02"></path><path d="M2 12a10 10 0 0 1 18-6"></path><path d="M2 16h.01"></path><path d="M21.8 16c.2-2 .131-5.354 0-6"></path><path d="M5 19.5C5.5 18 6 15 6 12a6 6 0 0 1 .34-2"></path><path d="M8.65 22c.21-.66.45-1.32.57-2"></path><path d="M9 6.8a6 6 0 0 1 9 5.2v2"></path></svg> Biometric Authentication
                  </div>
                  <div class="text-muted fw-bold" style="font-size: 12px;">Secure your account with fingerprint, face recognition, or device authentication</div>
                </div>
                <div class="card-body">
                  <div class="d-flex align-items-center justify-content-between">
                    <div>
                      <p class="fw-bold">Status</p>
                      <p class="text-sm text-muted">Not enrolled</p>
                    </div>
                    <div class="badge bg-secondary-subtle text-dark" style="font-size: 12px;"><i class="bi bi-shield"></i> Inactive</div>
                  </div>
                  <div>
                    <p class="fw-bold mb-2">Available Methods</p>
                    <div>
                      <div class="badge bg-primary-subtle text-primary mb-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M12 10a2 2 0 0 0-2 2c0 1.02-.1 2.51-.26 4"></path><path d="M14 13.12c0 2.38 0 6.38-1 8.88"></path><path d="M17.29 21.02c.12-.6.43-2.3.5-3.02"></path><path d="M2 12a10 10 0 0 1 18-6"></path><path d="M2 16h.01"></path><path d="M21.8 16c.2-2 .131-5.354 0-6"></path><path d="M5 19.5C5.5 18 6 15 6 12a6 6 0 0 1 .34-2"></path><path d="M8.65 22c.21-.66.45-1.32.57-2"></path><path d="M9 6.8a6 6 0 0 1 9 5.2v2"></path></svg>
                      Platform Authenticator</div>
                    </div>
                  </div>
                    <button class="w-100 btn btn-outline-primary mb-3"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="me-3"><path d="M12 10a2 2 0 0 0-2 2c0 1.02-.1 2.51-.26 4"></path><path d="M14 13.12c0 2.38 0 6.38-1 8.88"></path><path d="M17.29 21.02c.12-.6.43-2.3.5-3.02"></path><path d="M2 12a10 10 0 0 1 18-6"></path><path d="M2 16h.01"></path><path d="M21.8 16c.2-2 .131-5.354 0-6"></path><path d="M5 19.5C5.5 18 6 15 6 12a6 6 0 0 1 .34-2"></path><path d="M8.65 22c.21-.66.45-1.32.57-2"></path><path d="M9 6.8a6 6 0 0 1 9 5.2v2"></path></svg> Enroll Biometric Authentication</button>
                  <div class="text-muted p-0" style="font-size: 12px;">
                    <p class="p-0 m-0">• Your biometric data is stored securely on your device</p>
                    <p class="p-0 m-0">• Never has access to your biometric information</p>
                    <p class="p-0 m-0">• You can remove this authentication method at any time</p>
                  </div>
                </div>
              </div>
          </div><!-- End Default Tabs -->

        </div>
      </div>
    </section>

  </main><!-- End #main -->
<?php include('inc/footer.php'); } else {
    header('Location: auth-login.html');
    exit;
}