<?php include 'inc/funtions.php';
if (isset($_SESSION['user_type'])) {
    $user_id = $_SESSION['user_id'];
    $business_id = $_SESSION['business_id'];
    $user = getUserId($user_id);
    $pages_allowed = check_page_access();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    
    <link rel="stylesheet" href="assets/vendors/chartjs/Chart.min.css">
    <link rel="stylesheet" href="assets/vendors/simple-datatables/style.css">
    <link rel="stylesheet" href="assets/vendors/perfect-scrollbar/perfect-scrollbar.css">
    <link rel="stylesheet" href="assets/css/app.css">
    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
</head>
<body>
    <div id="app">
        <?php include('inc/header.php'); ?>            
            <div class="main-content container-fluid">
                <div class="mb-4">
                    <h3>ATC Record</h3>
                    <nav aria-label="breadcrumb" class='breadcrumb-header'>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Truck Record</li>
                        </ol>
                    </nav>
                </div> 
                <?php
                // Initialize all 4 specific counts
                $in_service = 0;
                $on_trip = 0;
                $maintenance = 0;
                $inactive = 0;

                $status_sql = Querydb("SELECT current_status, COUNT(*) as total FROM trucks WHERE business_id = '$business_id' GROUP BY current_status");

                foreach ($status_sql as $row) {
                    switch ($row['current_status']) {
                        case 'In Service':  $in_service = $row['total']; break;
                        case 'On Trip':     $on_trip = $row['total'];    break;
                        case 'Maintenance': $maintenance = $row['total']; break;
                        case 'Inactive':    $inactive = $row['total'];    break;
                    }
                }

                $total_fleet = $in_service + $on_trip + $maintenance + $inactive;
                ?>
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card shadow-sm border-0 border-start border-success border-4">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="text-uppercase mb-1 small fw-bold text-muted">In Service</h6>
                                        <h3 class="fw-bold mb-0 text-success"><?php echo number_format($in_service); ?></h3>
                                        <small class="text-muted">Available Trucks</small>
                                    </div>
                                    <div class="bg-light-success p-3 rounded-circle">
                                        <i class="bi bi-check-circle text-success fs-4"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="card shadow-sm border-0 border-start border-primary border-4">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="text-uppercase mb-1 small fw-bold text-muted">On Trip</h6>
                                        <h3 class="fw-bold mb-0 text-primary"><?php echo number_format($on_trip); ?></h3>
                                        <small class="text-muted">Currently Active</small>
                                    </div>
                                    <div class="bg-light-primary p-3 rounded-circle">
                                        <i class="bi bi-truck text-primary fs-4"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="card shadow-sm border-0 border-start border-warning border-4">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="text-uppercase mb-1 small fw-bold text-muted">Maintenance</h6>
                                        <h3 class="fw-bold mb-0 text-warning"><?php echo number_format($maintenance); ?></h3>
                                        <small class="text-muted">Under Repair</small>
                                    </div>
                                    <div class="bg-light-warning p-3 rounded-circle">
                                        <i class="bi bi-tools text-warning fs-4"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="card shadow-sm border-0 border-start border-danger border-4">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="text-uppercase mb-1 small fw-bold text-muted">Out of Service</h6>
                                        <h3 class="fw-bold mb-0 text-danger"><?php echo number_format($inactive); ?></h3>
                                        <small class="text-muted">Inactive Trucks</small>
                                    </div>
                                    <div class="bg-light-danger p-3 rounded-circle">
                                        <i class="bi bi-x-circle text-danger fs-4"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <section class="section">
                    <div class="row mb-4">
                        <div class="">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h4 class="card-title">Truck Record</h4>
                                    <div class="d-flex ">
                                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#addtruckrecord"><i data-feather="plus"></i> Add Truck</button>
                                    </div>
                                </div>
                                <div class="card-body px-0 pb-0">
                                    <div class="table-responsive p-3">
                                        <table class='table table-striped mb-0 text-center' id="table1">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Truck Lincense</th>
                                                    <th>Driver Name</th>
                                                    <th>Fuel</th>
                                                    <th>Registration Date</th>
                                                    <th>Registration End</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                $count = 1;
                                                $sql = Querydb("SELECT * FROM trucks WHERE business_id = '$business_id' Order by truck_id desc");
                                                    foreach ($sql as $key => $truck) { 
                                                    $drivers = Querydb("SELECT * FROM drivers WHERE driver_id = {$truck['driver_id']} AND business_id = '$business_id' ");
                                                    $driver = mysqli_fetch_assoc($drivers);

                                                        ?>
                                                <tr>
                                                    <td><?php echo $count; ?></td>
                                                    <td><?php echo $truck['license_plate']; ?></td>
                                                    <td>
                                                        <?php 
                                                        if (!empty($driver['first_name'])) {
                                                            echo htmlspecialchars($driver['first_name'] . " " . $driver['middle_name'] . " " . $driver['last_name']);
                                                        } else {
                                                            echo '<span class="text-muted italic">Unassigned</span>';
                                                        }
                                                        ?>
                                                    </td>
                                                    <td><?php echo $truck['initial_fuel'] ?></td>
                                                    <td><?php echo $truck['registration_start']; ?></td>
                                                    <td><?php echo $truck['registration_end']; ?></td>
                                                    <td>
                                                        <?php echo $truck['current_status'] ?>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <?php if ($_SESSION['user_type'] != 'Admin' || $_SESSION['user_type'] == "Manager") {?>
                                                                <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#viewtrucktruckModal<?php echo $truck['truck_id']; ?>"><i data-feather="eye"></i></button>
                                                            <?php } else {?>
                                                            <button type="submit" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#edittrucktruckModal<?php echo $truck['truck_id']; ?>"><i data-feather="edit"></i></button>
                                                            <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#viewtrucktruckModal<?php echo $truck['truck_id']; ?>"><i data-feather="eye"></i></button>
                                                        <?php } ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <div class="modal" id="edittrucktruckModal<?php echo $truck['truck_id']; ?>">
                                                    <div class="modal-dialog modal-dialog-centered">
                                                        <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">Edit Truck</h4>
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                        </div>
                                                        <div class="modal-body row">                                                            
                                                            <form class="g-3 needs-validation" novalidate>
                                                                <div class="row">
                                                                    <div class="col-md-6 col-12">
                                                                        <input type="hidden" id="truck_id_<?php echo $count; ?>" value="<?php echo $truck['truck_id']; ?>">
                                                                        <div class="form-group">
                                                                            <label for="truck_no_column">Truck license Number</label>
                                                                            <input type="text" id="license_plate_<?php echo $count; ?>" class="form-control" value="<?php echo $truck['license_plate']; ?>">
                                                                                
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6 col-12">
                                                                        <div class="form-group">
                                                                            <label for="last-name-column">Make</label>
                                                                            <input type="text" id="make_<?php echo $count; ?>" class="form-control" value="<?php echo $truck['make']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6 col-12">
                                                                        <div class="form-group">
                                                                            <label for="model-column">Model</label>
                                                                            <input type="text" id="model_<?php echo $count; ?>" class="form-control" placeholder="Model" value="<?php echo $truck['model']; ?>">
                                                                        </div>
                                                                    </div>                        
                                                                    <div class="col-md-6 col-12">
                                                                        <div class="form-group">
                                                                            <label for="year-column">Year</label>
                                                                            <input type="text" id="year_<?php echo $count; ?>" class="form-control"  value="<?php echo $truck['year']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6 col-12">
                                                                        <div class="form-group">
                                                                            <label for="vin-column">VIN</label>
                                                                            <input type="text" id="vin_<?php echo $count; ?>" class="form-control" value="<?php echo $truck['VIN']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6 col-12">
                                                                        <div class="form-group">
                                                                            <label for="vin-column">Registration Start</label>
                                                                            <input type="date" id="registration_column_<?php echo $count; ?>" class="form-control" value="<?php echo $truck['registration_start']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6 col-12">
                                                                        <div class="form-group">
                                                                            <label for="vin-column">Registration Start</label>
                                                                            <input type="date" id="registration_end_<?php echo $count; ?>" class="form-control" value="<?php echo $truck['registration_end']; ?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-6 col-12">
                                                                        <div class="form-group">
                                                                            <label for="driver-colum">Driver</label>
                                                                            <select class="choices form-select" id="driver_id_<?php echo $count; ?>">
                                                                                <option value="" disabled selected>Select Driver</option>
                                                                                <?php 
                                                                                $sql = Querydb("SELECT * FROM drivers WHERE business_id = '$business_id' AND is_active = 0 || driver_id = '{$truck['driver_id']}' order by driver_id desc");
                                                                                foreach ($sql as $driver) { ?>
                                                                                <option value="<?php echo $driver['driver_id']; ?>" <?php if ($driver['driver_id'] == $truck['driver_id']) echo 'selected'; ?>><?php echo $driver['first_name']." ".$driver['last_name']," ".$driver['middle_name']; ?></option>
                                                                                <?php } ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-12">
                                                                        <div class="form-group">
                                                                            <label for="current_status_<?php echo $count; ?>">Truck Status</label>
                                                                            <select class="choices form-select" id="current_status_<?php echo $count; ?>">
                                                                                <option value="" disabled selected>Select Truck Status</option>
                                                                                <option value="In Service" <?php if($truck['current_status'] == 'In Service'){echo 'Selected';} ?>>In Service</option>
                                                                                <option value="Maintenance" <?php if($truck['current_status'] == 'Maintenance'){echo 'Selected';} ?>>Maintenance</option>
                                                                                <option value="Inactive" <?php if($truck['current_status'] == 'Inactive'){echo 'Selected';} ?>>Inactive</option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>

                                                        <!-- Modal footer -->
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn bt n-danger" data-bs-dismiss="modal">Close</button>
                                                            <button class="btn btn-primary" type="submit" id="edittruckModalbtn_<?php echo $count; ?>">Submit</button> 
                                                        </div>

                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- View truck$truck Modal --> 
                                                <div class="modal fade" id="viewtrucktruckModal<?php echo $truck['truck_id']; ?>" tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered">
                                                        <div class="modal-content border-0 shadow-lg rounded-4">
                                                            <div class="modal-header text-dark rounded-top-4 p-4">
                                                                <h5 class="modal-title fw-bold">
                                                                    <i class="fas fa-truck me-2"></i> Truck Details
                                                                </h5>
                                                                <button type="button" class="btn-close btn-close-dark" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            
                                                            <div class="modal-body p-4">
                                                                <div class="text-center mb-4">
                                                                    <span class="badge bg-primary-subtle fs-3 text-primary rounded-pill px-3 py-2 mb-2">
                                                                        License: <?php echo $truck['license_plate']; ?>
                                                                    </span>
                                                                    <h4 class="fw-bold mb-0"><?php echo $truck['make'] . " " . $truck['model']; ?></h4>
                                                                    <p class="text-muted small">VIN: <?php echo $truck['VIN']; ?> • Year: <?php echo $truck['year']; ?></p>
                                                                </div>

                                                                <div class="list-group list-group-flush border rounded-3">
                                                                    <div class="list-group-item d-flex justify-content-between align-items-center py-3">
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="icon-box bg-light rounded-circle p-2 me-3">
                                                                                <i class="fas fa-id-badge text-primary"></i>
                                                                            </div>
                                                                            <span class="text-muted small fw-bold">ASSIGNED DRIVER</span>
                                                                        </div>
                                                                        <span class="fw-bold"><?php echo $driver['first_name']." ".$driver['last_name']; ?></span>
                                                                    </div>

                                                                    <div class="list-group-item d-flex justify-content-between align-items-center py-3">
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="icon-box bg-light rounded-circle p-2 me-3">
                                                                                <i class="fas fa-calendar-check text-success"></i>
                                                                            </div>
                                                                            <span class="text-muted small fw-bold">REG. START</span>
                                                                        </div>
                                                                        <span class="fw-bold text-dark"><?php echo date('M d, Y', strtotime($truck['registration_start'])); ?></span>
                                                                    </div>

                                                                    <div class="list-group-item d-flex justify-content-between align-items-center py-3">
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="icon-box bg-light rounded-circle p-2 me-3">
                                                                                <i class="fas fa-calendar-times text-danger"></i>
                                                                            </div>
                                                                            <span class="text-muted small fw-bold">REG. EXPIRY</span>
                                                                        </div>
                                                                        <span class="fw-bold text-dark"><?php echo date('M d, Y', strtotime($truck['registration_end'])); ?></span>
                                                                    </div>
                                                                    <div class="list-group-item d-flex justify-content-between align-items-center py-3">
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="icon-box bg-light rounded-circle p-2 me-3">
                                                                                <i class="fas fa-calendar-times text-danger"></i>
                                                                            </div>
                                                                            <span class="text-muted small fw-bold">Fuel</span>
                                                                        </div>
                                                                        <span class="fw-bold text-dark"><?php echo $truck['initial_fuel']; ?></span>
                                                                    </div>
                                                                </div>

                                                                <?php 
                                                                $expiry = strtotime($truck['registration_end']);
                                                                $now = time();
                                                                if($expiry < $now): ?>
                                                                    <div class="alert alert-danger border-0 mt-3 rounded-3 small">
                                                                        <i class="fas fa-exclamation-triangle me-2"></i> Registration has expired.
                                                                    </div>
                                                                <?php endif; ?>
                                                            </div>
                                                            
                                                            <div class="modal-footer border-0 p-4">
                                                                <button type="button" class="btn btn-dark w-100 rounded-1 px-4 fw-bold" data-bs-dismiss="modal">Close</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php $count++; } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
<?php  include('inc/footer.php'); 
} else {
    header('Location: pages-error-404.html');
    exit;
}?>
