<?php include 'inc/funtions.php';
if (isset($_SESSION['user_type'])) {
    $user_id = $_SESSION['user_id'];
    $business_id = $_SESSION['business_id'];
    $user = getUserId($user_id);
    $pages_allowed = check_page_access();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    
    <link rel="stylesheet" href="assets/vendors/chartjs/Chart.min.css">
    <link rel="stylesheet" href="assets/vendors/simple-datatables/style.css">
    <link rel="stylesheet" href="assets/vendors/perfect-scrollbar/perfect-scrollbar.css">
    <link rel="stylesheet" href="assets/css/app.css">
    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
</head>
<body>
    <div id="app">
        <?php include('inc/header.php'); ?>            
            <div class="main-content container-fluid">
                <div class="mb-4">
                    <h3>Driver Record</h3>
                    <nav aria-label="breadcrumb" class='breadcrumb-header'>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Driver Record</li>
                        </ol>
                    </nav>
                </div> 
                <section class="section">
                    <?php
                    $res = Querydb("SELECT * FROM orders WHERE status = 'Pending' AND business_id = '$business_id' ORDER BY id DESC");
                    ?>

                    <div class="card border-0 shadow-sm p-3 rounded-4">
                        <div class="card-header bg-white py-3"><h5 class="fw-bold mb-0">Pending Logistics Dispatch</h5></div>
                        <div class="table-responsive">
                            <table class="table table-striped align-middle p-5 mb-0" id="table1">
                                <thead>
                                    <tr class="text-center">
                                        <th>ORDER ID</th>
                                        <th>PRODUCT</th>
                                        <th>DATE</th>
                                        <th>LOCATION</th>
                                        <th>ACTION</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php while($row = mysqli_fetch_assoc($res)) { ?>
                                    <tr class="text-center">
                                        <td class="px-3"><strong><?php echo $row['order_id']; ?></strong></td>
                                        <td><?php echo $row['product_name']; ?> (<?php echo $row['quantity']; ?>)</td>
                                        <td class="fw-bold"><?php echo $row['order_date']; ?></td>
                                        <td class="fw-bold"><?php echo $row['location']; ?></td>
                                        <td class="text-center px-3">
                                            <button class="btn btn-primary btn-sm rounded-pill px-3" 
                                                    data-bs-toggle="modal" data-bs-target="#dispatchModal<?php echo $row['id']; ?>">
                                                Assign ATC & Driver
                                            </button>
                                        </td>
                                    </tr>
                                    <div class="modal fade" id="dispatchModal<?php echo $row['id']; ?>" tabindex="-1">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <form action="" method="POST" class="modal-content border-0 rounded-4">
                                                    <div class="modal-header border-0">
                                                        <h5 class="fw-bold">Dispatch Log: <span id="display_order_id"><?php echo $row['order_id']; ?></span></h5>
                                                    </div>
                                                    <div class="modal-body">
                                                        <input type="hidden" name="id" id="order_id_<?php echo $row['id']; ?>" value="<?php echo $row['order_id']; ?>">
                                                        
                                                        <div class="mb-3">
                                                            <div class="form-group">
                                                                <label class="small fw-bold text-muted" for="atc-column">ATC Number</label>
                                                                <select class="choices form-select" id="atc-colum_<?php echo $row['id']; ?>">
                                                                    <option value="" disabled selected>Select ATC Number</option>
                                                                    <?php 
                                                                    $sql = Querydb("select * from atc_records where atc_status = 'Open' and business_id = '$business_id'");
                                                                    foreach ($sql as $atc) { ?>
                                                                    <option value="<?php echo $atc['atc_id']; ?>"><?php echo $atc['atc_number']." (".$atc['type'].")"; ?></option>
                                                                    <?php } ?>
                                                                </select>
                                                            </div>
                                                        </div>

                                                        <div class="mb-3">
                                                            <div class="form-group">
                                                                <label class="small fw-bold text-muted" for="customer-colum">Customer</label>
                                                                <select class="choices form-select" id="customer-colum_<?php echo $row['id']; ?>" disabled readonly>
                                                                    <?php 
                                                                    $sql = Querydb("select * from customers where customer_id = '{$row['customer_id']}'");
                                                                    foreach ($sql as $customer) { ?>
                                                                    <option value="<?php echo $customer['customer_id']; ?>"<?php if($customer['customer_id'] == $row['customer_id']){echo 'selected';} ?>><?php echo $customer['name']." (".$customer['phone'].")"; ?></option>
                                                                    <?php } ?>
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="small fw-bold text-muted">QTY/UNIT</label>
                                                            <input type="number" id="unit_<?php echo $row['id']; ?>" class="form-control" value="<?php echo $row['quantity'] ?>" readonly>
                                                        </div>
                                                        <div class="row g-2 mb-3">
                                                            <div class="col-6">
                                                                <label class="small fw-bold text-muted">COST PRICE (₦)</label>
                                                                <input type="number" id="cost_price_<?php echo $row['id']; ?>" class="form-control" required>
                                                            </div>
                                                            <div class="col-6">
                                                                <label class="small fw-bold text-muted">SELLING PRICE (₦)</label>
                                                                <input type="number" id="selling_price_<?php echo $row['id']; ?>" name="selling_price" class="form-control">
                                                            </div>
                                                        </div>

                                                        <div class="mb-3">
                                                            <label class="small fw-bold text-muted">DRIVER ALLOWANCE (₦)</label>
                                                            <input type="number" id="driver_allowance_<?php echo $row['id']; ?>" class="form-control" required>
                                                        </div>
                                                        
                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label class="small fw-bold text-muted" for="location-column">Location</label>
                                                                <textarea type="text" id="location-column_<?php echo $row['id']; ?>" rows="5" class="form-control" placeholder="Location" readonly><?php echo $row['location']; ?></textarea>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="modal-footer border-0">
                                                        <button type="submit" class="btn btn-primary w-100 rounded-pill fw-bold" id="o-dispatch_<?php echo $row['id']; ?>">Confirm Dispatch</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <?php }; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>

            </div>
<?php  include('inc/footer.php'); 
} else {
    header('Location: pages-error-404.html');
    exit;
}?>
