<?php include 'inc/funtions.php';
if (isset($_SESSION['user_type'])) {
    $user_id = $_SESSION['user_id'];
    $business_id = $_SESSION['business_id'];
    $user = getUserId($user_id);
    $pages_allowed = check_page_access();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    
    <link rel="stylesheet" href="assets/vendors/chartjs/Chart.min.css">
    <link rel="stylesheet" href="assets/vendors/simple-datatables/style.css">
    <link rel="stylesheet" href="assets/vendors/perfect-scrollbar/perfect-scrollbar.css">
    <link rel="stylesheet" href="assets/css/app.css">
    <link rel="stylesheet" type="text/css" href="assets/vendors/select2/select2.min.css">
    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
<!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script> -->
</head>    
<body>
    <div id="app">
        <?php include('inc/header.php'); ?>            
            <div class="main-content container-fluid">
                <div class="mb-4">
                    <h3>    Expense Record</h3>
                    <nav aria-label="breadcrumb" class='breadcrumb-header'>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
                            <li class="breadcrumb-item active" aria-current="page"> Expense Record</li>
                        </ol>
                    </nav>
                </div> 
                <section class="section">
                    <div class="row mb-4">
                        <div class="">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h4 class="card-title"> Expense Record</h4>
                                    <div class="d-flex ">
                                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#maintencemodal"><i data-feather="plus"></i> Create New Expense</button>
                                    </div>
                                </div>
                                <div class="row mb-3 align-items-end">
                                    <div class="col-md-12">
                                        <form id="filterForm" method="GET" action="" class="p-3 rounded border">
                                            <div class="row align-items-end g-2">
                                                <div class="col-md-3">
                                                    <label class="small fw-bold text-muted">Filter Type</label>
                                                    <select name="filter" id="filterSelect" class="form-select form-select-sm" onchange="toggleDateInputs()">
                                                        <option value="day" <?php if($filter == 'day') echo 'selected'; ?>>Today</option>
                                                        <option value="week" <?php if($filter == 'week') echo 'selected'; ?>>This Week</option>
                                                        <option value="month" <?php if($filter == 'month') echo 'selected'; ?>>This Month</option>
                                                        <option value="year" <?php if($filter == 'year') echo 'selected'; ?>>This Year</option>
                                                        <option value="custom" <?php if($filter == 'custom') echo 'selected'; ?>>Custom Range</option>
                                                    </select>
                                                </div>

                                                <div id="customDates" class="col-md-7 <?php echo ($filter == 'custom') ? '' : 'd-none'; ?>">
                                                    <div class="row g-2">
                                                        <div class="col-6">
                                                            <label class="small fw-bold text-muted">Start Date</label>
                                                            <input type="date" name="start_date" class="form-control form-control-sm" value="<?php echo $_GET['start_date'] ?? ''; ?>">
                                                        </div>
                                                        <div class="col-6">
                                                            <label class="small fw-bold text-muted">End Date</label>
                                                            <input type="date" name="end_date" class="form-control form-control-sm" value="<?php echo $_GET['end_date'] ?? ''; ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-md-2">
                                                    <button type="submit" class="btn btn-sm btn-dark w-100">Apply Filter</button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>

                                    <!-- <div class="col-md-6 text-end">
                                        <button class="btn btn-danger" onclick="exportPDF()">Export PDF</button>
                                        <button class="btn btn-success" onclick="exportExcel()">Export Excel</button>
                                    </div> -->
                                </div>
                                <div class="card-body px-0 pb-0">
                                    <div class="card border-0 shadow-sm rounded-4 p-4">
                                        <ul class="nav nav-pills mb-4 bg-light p-1 rounded-pill" id="profileTabs" role="tablist">
                                            <li class="nav-item flex-fill">
                                                <button class="nav-link active rounded-pill w-100 fw-bold" data-bs-toggle="pill" data-bs-target="#tab-info">Expense Pre Trucks</button>
                                            </li>
                                            <li class="nav-item flex-fill">
                                                <button class="nav-link rounded-pill w-100 fw-bold" data-bs-toggle="pill" data-bs-target="#tab-vendor">Expense Pre Vendor</button>
                                            </li>
                                            <li class="nav-item flex-fill">
                                                <button class="nav-link rounded-pill w-100 fw-bold" data-bs-toggle="pill" data-bs-target="#tab-security">Expense</button>
                                            </li>
                                        </ul>

                                        <div class="tab-content">
                                            <div class="tab-pane fade show active" id="tab-info">
                                                <div class="table-responsive p-3">
                                                <?php 
                                                    $count = 1;
                                                    $total_fleet_cost = 0; 
                                                    $all_modals = ""; 

                                                    $filter = $_GET['filter'] ?? 'month'; // Default to month
                                                    $date_filter = ""; 

                                                    // Handle Preset Filters
                                                    if ($filter == 'day') {
                                                        $date_filter = " AND DATE(date_performed) = CURDATE() AND business_id = '$business_id'";
                                                    } elseif ($filter == 'week') {
                                                        $date_filter = " AND YEARWEEK(date_performed, 1) = YEARWEEK(CURDATE(), 1) AND business_id = '$business_id'";
                                                    } elseif ($filter == 'month') {
                                                        $date_filter = " AND MONTH(date_performed) = MONTH(CURDATE()) AND YEAR(date_performed) = YEAR(CURDATE()) AND business_id = '$business_id'";
                                                    } elseif ($filter == 'year') {
                                                        $date_filter = " AND YEAR(date_performed) = YEAR(CURDATE()) AND business_id = '$business_id'";
                                                    } 
                                                    // Handle Custom Range
                                                    elseif ($filter == 'custom' && !empty($_GET['start_date']) && !empty($_GET['end_date'])) {
                                                        $start = mysqli_real_escape_string($conn, $_GET['start_date']);
                                                        $end = mysqli_real_escape_string($conn, $_GET['end_date']);
                                                        $date_filter = " AND date_performed BETWEEN '$start' AND '$end' AND business_id = '$business_id'";
                                                    }
                                                                                                        

                                                    // Optimized Query: Gets latest record AND total spent per truck
                                                    $query = "SELECT m.*, 
                                                              (SELECT SUM(cost) FROM maintenance WHERE truck_id = m.truck_id $date_filter) as total_spent_per_truck
                                                              FROM maintenance m 
                                                              WHERE m.maintenance_id IN (SELECT MAX(maintenance_id) FROM maintenance GROUP BY truck_id) 
                                                              $date_filter 
                                                              ORDER BY m.date_performed DESC";

                                                    $main_sql = Querydb($query);
                                                    ?>

                                                    <table class="table" id="table1">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Truck License</th>
                                                                <th>Expense Type</th>
                                                                <th>Latest Expense</th>
                                                                <th>Latest Cost</th>
                                                                <th>Date</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($main_sql as $maintence): 
                                                                $total_fleet_cost += $maintence['cost']; // Sum for the bottom of the table
                                                                $truck_query = Querydb("SELECT * FROM trucks WHERE truck_id = '{$maintence['truck_id']}' AND business_id = '$business_id'");
                                                                $truck = mysqli_fetch_assoc($truck_query);
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $count; ?></td>
                                                                    <td><span class="badge bg-dark"><?php echo $truck['license_plate'] ?? 'No Truck Selected'; ?></span></td>
                                                                    <td><?php echo $maintence['service_type']; ?></td>
                                                                    <td>₦ <?php echo number_format($maintence['cost'], 2); ?></td>
                                                                    
                                                                    <td class="fw-bold text-success">
                                                                        ₦ <?php echo number_format($maintence['total_spent_per_truck'], 2); ?>
                                                                    </td>
                                                                    
                                                                    <td><?php echo date('M d, Y', strtotime($maintence['date_performed'])); ?></td>
                                                                    <td>
                                                                        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#viewModal<?php echo $maintence['maintenance_id']; ?>">
                                                                            <i data-feather="eye"></i> View
                                                                        </button>
                                                                    </td>
                                                                </tr>

                                                                <?php 
                                                                // 3. CAPTURE MODALS IN A VARIABLE (Buffered)
                                                                ob_start(); ?>
                                                                <div class="modal fade" id="viewModal<?php echo $maintence['maintenance_id']; ?>" tabindex="-1">
                                                                    <div class="modal-dialog modal-lg">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header border-0 pb-0">
                                                                                <h4 class="modal-title fw-bold text-primary">Service Details: <?php echo $truck['license_plate'] ?? 'No Truck Selected'; ?></h4>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <div class="row g-3 mb-4 text-center">
                                                                                    <div class="col-4">
                                                                                        <div class="p-3 border rounded bg-light">
                                                                                            <small class="text-muted d-block">Cost</small>
                                                                                            <span class="fw-bold">₦<?php echo number_format($maintence['cost'], 2); ?></span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-4">
                                                                                        <div class="p-3 border rounded bg-light">
                                                                                            <small class="text-muted d-block">Type</small>
                                                                                            <span class="fw-bold"><?php echo $maintence['service_type']; ?></span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-4">
                                                                                        <div class="p-3 border rounded bg-light">
                                                                                            <small class="text-muted d-block">Date</small>
                                                                                            <span class="fw-bold"><?php echo date('d M Y', strtotime($maintence['date_performed'])); ?></span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-12 text-start">
                                                                                        <label class="small text-muted">Work Description:</label>
                                                                                        <p class="p-2 border rounded shadow-sm bg-white"><?php echo $maintence['description']; ?></p>
                                                                                    </div>
                                                                                </div>

                                                                                <hr>

                                                                                <h6 class="fw-bold mb-3"><i data-feather="clock" class="icon-sm"></i> Full Service History for this Truck</h6>
                                                                                <div class="table-responsive">
                                                                                    <table class="table table-sm table-striped small" id="table1">
                                                                                        <thead>
                                                                                            <tr class="table-light">
                                                                                                <th>Date</th>
                                                                                                <th>Service Type</th>
                                                                                                <th>Description</th>
                                                                                                <th class="text-end">Cost</th>
                                                                                            </tr>
                                                                                        </thead>
                                                                                        <tbody>
                                                                                            <?php 
                                                                                            $t_id = $maintence['truck_id'];
                                                                                            $history_sql = Querydb("SELECT * FROM maintenance WHERE truck_id = '$t_id' $date_filter ORDER BY date_performed DESC");
                                                                                            foreach ($history_sql as $h_row) {
                                                                                            ?>
                                                                                            <tr>
                                                                                                <td><?php echo date('d/m/Y', strtotime($h_row['date_performed'])); ?></td>
                                                                                                <td><span class="badge bg-secondary-light text-secondary"><?php echo $h_row['service_type']; ?></span></td>
                                                                                                <td><small><?php echo substr($h_row['description'], 0, 40); ?>...</small></td>
                                                                                                <td class="text-end fw-bold">₦<?php echo number_format($h_row['cost'], 2); ?></td>

                                                                                            </tr>
                                                                                            <?php } ?>
                                                                                        </tbody>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                            <div class="modal-footer border-0">
                                                                                <button type="button" class="btn btn-secondary w-100" data-bs-dismiss="modal">Close Preview</button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <?php 
                                                                $all_modals .= ob_get_clean(); 
                                                                $count++; 
                                                            endforeach; ?>
                                                        </tbody>
                                                    </table>

                                                    <?php 
                                                    // 4. ECHO MODALS AFTER TABLE IS CLOSED
                                                    echo $all_modals; 
                                                    ?>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="tab-vendor">
                                                <div class="table-responsive p-3">
                                                <?php 
                                                    $count = 1;
                                                    $total_fleet_cost = 0; 
                                                    $all_modals = ""; 

                                                    $filter = $_GET['filter'] ?? 'month'; // Default to month
                                                    $date_filters = ""; 

                                                    // Handle Preset Filters
                                                    if ($filter == 'day') {
                                                        $date_filters = " AND DATE(date_performed) = CURDATE()";
                                                    } elseif ($filter == 'week') {
                                                        $date_filters = " AND YEARWEEK(date_performed, 1) = YEARWEEK(CURDATE(), 1)";
                                                    } elseif ($filter == 'month') {
                                                        $date_filters = " AND MONTH(date_performed) = MONTH(CURDATE()) AND YEAR(date_performed) = YEAR(CURDATE())";
                                                    } elseif ($filter == 'year') {
                                                        $date_filters = " AND YEAR(date_performed) = YEAR(CURDATE())";
                                                    } 
                                                    // Handle Custom Range
                                                    elseif ($filter == 'custom' && !empty($_GET['start_date']) && !empty($_GET['end_date'])) {
                                                        $start = mysqli_real_escape_string($conn, $_GET['start_date']);
                                                        $end = mysqli_real_escape_string($conn, $_GET['end_date']);
                                                        $date_filters = " AND date_performed BETWEEN '$start' AND '$end'";
                                                    }
                                                                                                        

                                                    // Optimized Query: Gets latest record AND total spent per truck
                                                    $query = "SELECT m.*, 
                                                           IF(m.vendor_id = 0 OR u.user_id IS NULL, 'Other', CONCAT(u.first_name, ' ', u.last_name)) as vendor_name,
                                                           stats.total_spent_per_truck
                                                    FROM maintenance m
                                                    LEFT JOIN users u ON m.vendor_id = u.user_id
                                                    LEFT JOIN (
                                                        SELECT vendor_id, SUM(cost) as total_spent_per_truck 
                                                        FROM maintenance WHERE business_id = '$business_id' $date_filters
                                                        GROUP BY vendor_id
                                                    ) stats ON m.vendor_id = stats.vendor_id
                                                    WHERE 1=1 $date_filters AND m.business_id = '$business_id' GROUP BY vendor_id
                                                    ORDER BY m.date_performed DESC";

                                                    $main_sql = Querydb($query);
                                                    ?>

                                                    <table class="table" id="table1">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                <th>Truck License</th>
                                                                <th>Expense Type</th>
                                                                <th>Latest Expense</th>
                                                                <th>Latest Cost</th>
                                                                <th>Date</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($main_sql as $maintence): 
                                                                $total_fleet_cost += $maintence['cost']; 
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $count; ?></td>
                                                                    <td><span class="badge bg-dark"><?php echo $maintence['vendor_name']; ?></span></td>
                                                                    <td><?php echo $maintence['service_type']; ?></td>
                                                                    <td>₦ <?php echo number_format($maintence['cost'], 2); ?></td>
                                                                    
                                                                    <td class="fw-bold text-success">
                                                                        ₦ <?php echo number_format($maintence['total_spent_per_truck'], 2); ?>
                                                                    </td>
                                                                    
                                                                    <td><?php echo date('M d, Y', strtotime($maintence['date_performed'])); ?></td>
                                                                    <td>
                                                                        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#viewModalVendor<?php echo $count; ?>">
                                                                            <i data-feather="eye"></i> View
                                                                        </button>
                                                                    </td>
                                                                </tr>

                                                                <?php 
                                                                // 3. CAPTURE MODALS IN A VARIABLE (Buffered)
                                                                ob_start(); ?>
                                                                <div class="modal fade" id="viewModalVendor<?php echo $count; ?>" tabindex="-1">
                                                                    <div class="modal-dialog modal-lg">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header border-0 pb-0">
                                                                                <h4 class="modal-title fw-bold text-primary">Vendor Details: <?php echo $maintence['vendor_name']; ?></h4>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <div class="row g-3 mb-4 text-center">
                                                                                    <div class="col-4">
                                                                                        <div class="p-3 border rounded bg-light">
                                                                                            <small class="text-muted d-block">Cost</small>
                                                                                            <span class="fw-bold">₦<?php echo number_format($maintence['cost'], 2); ?></span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-4">
                                                                                        <div class="p-3 border rounded bg-light">
                                                                                            <small class="text-muted d-block">Type</small>
                                                                                            <span class="fw-bold"><?php echo $maintence['service_type']; ?></span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-4">
                                                                                        <div class="p-3 border rounded bg-light">
                                                                                            <small class="text-muted d-block">Date</small>
                                                                                            <span class="fw-bold"><?php echo date('d M Y', strtotime($maintence['date_performed'])); ?></span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-12 text-start">
                                                                                        <label class="small text-muted">Work Description:</label>
                                                                                        <p class="p-2 border rounded shadow-sm bg-white"><?php echo $maintence['description']; ?></p>
                                                                                    </div>
                                                                                </div>

                                                                                <hr>

                                                                                <h6 class="fw-bold mb-3"><i data-feather="clock" class="icon-sm"></i> Full Service History for this Truck</h6>
                                                                                <div class="table-responsive">
                                                                                    <table class="table table-sm table-striped small" id="table1">
                                                                                        <thead>
                                                                                            <tr class="table-light">
                                                                                                <th>Date</th>
                                                                                                <th>Service Type</th>
                                                                                                <th>Description</th>
                                                                                                <th class="text-end">Cost</th>
                                                                                            </tr>
                                                                                        </thead>
                                                                                        <tbody>
                                                                                            <?php 
                                                                                            $t_id = $maintence['vendor_id'];
                                                                                            $history_sql = Querydb("SELECT * FROM maintenance WHERE vendor_id = '$t_id' $date_filter ORDER BY date_performed DESC");
                                                                                            foreach ($history_sql as $h_row) {
                                                                                            ?>
                                                                                            <tr>
                                                                                                <td><?php echo date('d/m/Y', strtotime($h_row['date_performed'])); ?></td>
                                                                                                <td><span class="badge bg-secondary-light text-secondary"><?php echo $h_row['service_type']; ?></span></td>
                                                                                                <td><small><?php echo substr($h_row['description'], 0, 40); ?>...</small></td>
                                                                                                <td class="text-end fw-bold">₦<?php echo number_format($h_row['cost'], 2); ?></td>

                                                                                            </tr>
                                                                                            <?php } ?>
                                                                                        </tbody>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                            <div class="modal-footer border-0">
                                                                                <button type="button" class="btn btn-secondary w-100" data-bs-dismiss="modal">Close Preview</button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <?php 
                                                                $all_modals .= ob_get_clean(); 
                                                                $count++; 
                                                            endforeach; ?>
                                                        </tbody>
                                                    </table>

                                                    <?php 
                                                    // 4. ECHO MODALS AFTER TABLE IS CLOSED
                                                    echo $all_modals; 
                                                    ?>
                                                </div>
                                            </div>

                                            <div class="tab-pane fade" id="tab-security">
                                                <div class="table-responsive p-3">
                                                    <?php 
                                                    $count = 1;
                                                    // Optional Date Filter Logic
                                                    $filter = $_GET['filter'] ?? 'month'; // Default to month
                                                    $date_query = ""; 

                                                    // Handle Preset Filters
                                                    if ($filter == 'day') {
                                                        $date_query = " WHERE DATE(date_performed) = CURDATE() AND business_id = '$business_id'";
                                                    } elseif ($filter == 'week') {
                                                        $date_query = " WHERE YEARWEEK(date_performed, 1) = YEARWEEK(CURDATE(), 1) AND business_id = '$business_id'";
                                                    } elseif ($filter == 'month') {
                                                        $date_query = " WHERE MONTH(date_performed) = MONTH(CURDATE()) AND YEAR(date_performed) = YEAR(CURDATE()) AND business_id = '$business_id'";
                                                    } elseif ($filter == 'year') {
                                                        $date_query = " WHERE YEAR(date_performed) = YEAR(CURDATE()) AND business_id = '$business_id'";
                                                    } 
                                                    // Handle Custom Range
                                                    elseif ($filter == 'custom' && !empty($_GET['start_date']) && !empty($_GET['end_date'])) {
                                                        $start = mysqli_real_escape_string($conn, $_GET['start_date']);
                                                        $end = mysqli_real_escape_string($conn, $_GET['end_date']);
                                                        $date_query = " WHERE date_performed BETWEEN '$start' AND '$end' AND business_id = '$business_id'";
                                                    }

                                                    // Optimized Query: Gets latest record AND total spent per truck
                                                    $query = "SELECT * FROM maintenance $date_query ORDER BY date_performed DESC";

                                                    $main_sql = Querydb($query);
                                                    ?>

                                                    <table class="table table-striped" id="table1">
                                                        <thead>
                                                            <tr> 
                                                                <th>#</th>
                                                                <th>Truck License</th>
                                                                <th>Expense Type</th>
                                                                <th>Expense</th>
                                                                <th>Date</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach ($main_sql as $maintence) { 
                                                                $t_id = $maintence['truck_id'];
                                                                $truck_query = Querydb("SELECT * FROM trucks WHERE truck_id = '$t_id' AND business_id = '$business_id'");
                                                                $truck_sql = mysqli_fetch_assoc($truck_query);
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $count; ?></td>
                                                                    <td><span class="badge bg-dark"><?php echo $truck_sql['license_plate'] ?? 'No Truck Selected'; ?></span></td>
                                                                    <td><?php echo $maintence['service_type'] . $maintence['truck_id']; ?></td>
                                                                    <td>₦ <?php echo number_format($maintence['cost'], 2); ?></td>
                                                                    
                                                                    <td><?php echo date('M d, Y', strtotime($maintence['date_performed'])); ?></td>
                                                                    <td>
                                                                        <button type="submit" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#editmaintenceModal<?php echo $count; ?>"><i data-feather="edit"></i> Edit</button>
                                                                        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#viewmaintenceModal<?php echo $count; ?>">
                                                                            <i data-feather="eye"></i> View
                                                                        </button>
                                                                    </td>
                                                                </tr>

                                                                <div class="modal" id="editmaintenceModal<?php echo $count; ?>">
                                                                    <div class="modal-dialog modal-dialog-centered">
                                                                        <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <h4 class="modal-title">Edit Maintenance</h4>
                                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                                        </div>
                                                                        <div class="modal-body row">
                                                                            <form class="g-3 needs-validation" novalidate>           
                                                                                <div class="col-lg-6 col-md-12 mb-3">
                                                                                    <input type="hidden" id="Maintence_id_<?php echo $count ?>" value="<?php echo $maintence['maintenance_id']; ?>">
                                                                                    <label for="truck_license_" class="form-label">Truck Licence</label>
                                                                                    <select class="form-control" id="trucklicense_<?php echo $count; ?>">
                                                                                        <option value="" disabled selected>Select Truck license</option>
                                                                                        <?php 
                                                                                        $sql = Querydb('select * from trucks order by driver_id desc');
                                                                                        foreach ($sql as $truck_sql) { ?>
                                                                                        <option value="<?php echo $truck_sql['truck_id']; ?>"<?php if($truck_sql['truck_id'] == $maintence['truck_id']){echo "selected";} ?>><?php echo $truck_sql['license_plate']; ?></option> 
                                                                                        <?php } ?>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="col-lg-6 col-md-12 mb-3">
                                                                                    <label for="Maintence_type" class="form-label">Maintence Type</label>
                                                                                    <select class="form-control" id="Maintence_type_<?php echo $count; ?>">
                                                                                        <option value="" disabled selected>Select Maintenance Type</option>
                                                                                        <option value="Tires"<?php if($maintence['service_type'] == 'Tires'){echo "selected";} ?>>Tires</option>
                                                                                        <option value="Engine"<?php if($maintence['service_type'] == 'Engine'){echo "selected";} ?>>Engine</option>
                                                                                        <option value="Fuel System"<?php if($maintence['service_type'] == 'Fuel System'){echo "selected";} ?>>Fuel System</option>
                                                                                        <option value="Routine Service"<?php if($maintence['service_type'] == 'Routine Service'){echo "selected";} ?>>Routine Service</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="col-lg-6 col-md-12 mb-3">
                                                                                    <label for="cost" class="form-label">Cost</label>
                                                                                    <input type="text" class="form-control" id="cost_<?php echo $count; ?>" value="<?php echo $maintence['cost'] ?>">
                                                                                </div>
                                                                                <div class="col-lg-6 col-md-12 mb-3">
                                                                                    <label for="datecarryout" class="form-label">Date</label>
                                                                                    <input type="date" class="form-control" id="datecarryout_<?php echo $count; ?>" value="<?php echo $maintence['date_performed'] ?>">
                                                                                </div>
                                                                                <div class="col-lg-12 col-md-12 mb-3">
                                                                                    <label for="vendor_id" class="form-label">Vendor</label>
                                                                                    <select class="form-control" id="vendor_id_<?php echo $count; ?>" required>
                                                                                        <option value="" disabled selected>Select Vendor</option>
                                                                                        <?php 
                                                                                        $sql = Querydb('select * from users where role_id = 3 order by user_id desc');
                                                                                        foreach ($sql as $vendor) { ?>
                                                                                        <option value="<?php echo $vendor['user_id']; ?>" <?php if($maintence['vendor_id'] == $vendor['user_id']){echo "selected";}?>><?php echo $vendor['first_name'].' '.$vendor['last_name'];; ?></option>
                                                                                        <?php } ?>
                                                                                        <option value="0"<?php if($maintence['vendor_id'] == 0){echo "selected";}?>>Other</option>
                                                                                    </select>
                                                                                </div>
                                                                                <div class="col-md-12">
                                                                                    <label for="Description" class="form-label">Description</label>
                                                                                    <textarea type="text" class="form-control" id="Description_<?php echo $count; ?>"><?php echo $maintence['description'] ?></textarea>
                                                                                </div>                                                            
                                                                            </form>
                                                                        </div>

                                                                        <!-- Modal footer -->
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn bt n-danger" data-bs-dismiss="modal">Close</button>
                                                                            <button class="btn btn-primary" type="submit" id="editmaintenceModalbtn_<?php echo $count; ?>">Submit</button> 
                                                                        </div>

                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- View maintence Modal --> 
                                                                <div class="modal fade" id="viewmaintenceModal<?php echo $count; ?>" tabindex="-1" aria-hidden="true">
                                                                    <div class="modal-dialog modal-dialog-centered">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                <h4 class="modal-title">Maintenance Details</h4>
                                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <div class="card-body">
                                                                                    <div class="row mb-3">
                                                                                        <div class="col-lg-4 col-md-4 text-muted small fw-bold">Truck License</div>
                                                                                        <div class="col-lg-8 col-md-8">
                                                                                            <h5 class="fw-bold text-dark"><?php echo $truck_sql['license_plate'] ?? 'No Truck Selected'; ?></h5>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class="row mb-3">
                                                                                        <div class="col-lg-4 col-md-4 text-muted small fw-bold">Service Type</div>
                                                                                        <div class="col-lg-8 col-md-8">
                                                                                            <span class="badge bg-light-primary text-primary"><?php echo htmlspecialchars($maintence['service_type']); ?></span>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class="row mb-3">
                                                                                        <div class="col-lg-4 col-md-4 text-muted small fw-bold">Total Cost</div>
                                                                                        <div class="col-lg-8 col-md-8 text-danger fw-bold">
                                                                                            ₦ <?php echo number_format($maintence['cost'], 2); ?>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class="row mb-3">
                                                                                        <div class="col-lg-4 col-md-4 text-muted small fw-bold">Vendor</div>
                                                                                        <div class="col-lg-8 col-md-8 text-success fw-bold">
                                                                                            <?php 
                                                                                                $v_id = (int)$maintence['vendor_id'];
                                                                                                if ($v_id > 0) {
                                                                                                    $vendor_d = Querydb("SELECT first_name, last_name FROM users WHERE user_id = $v_id AND role_id = 3 LIMIT 1");
                                                                                                    $v_info = mysqli_fetch_assoc($vendor_d);
                                                                                                    echo $v_info ? htmlspecialchars($v_info['first_name'] . ' ' . $v_info['last_name']) : "External Vendor";
                                                                                                } else {
                                                                                                    echo "Other / External Vendor";
                                                                                                }
                                                                                            ?>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class="row mb-3">
                                                                                        <div class="col-lg-4 col-md-4 text-muted small fw-bold">Date Performed</div>
                                                                                        <div class="col-lg-8 col-md-8">
                                                                                            <i class="bi bi-calendar-event me-1"></i> 
                                                                                            <?php echo date('M d, Y', strtotime($maintence['date_performed'])); ?>
                                                                                        </div>
                                                                                    </div>

                                                                                    <div class="row">
                                                                                        <div class="col-12 text-muted small fw-bold mb-1">Work Description</div>
                                                                                        <div class="col-12">
                                                                                            <p class="text-secondary small bg-light p-3 rounded border">
                                                                                                <?php echo nl2br(htmlspecialchars($maintence['description'])); ?>
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <?php  
                                                                $count++; 
                                                            } ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
<?php  include('inc/footer.php'); 
} else {
    header('Location: pages-error-404.html');
    exit;
}?>
