<?php include("inc/code.php"); ?>
<div id="sidebar" class='active'>
    <div class="sidebar-wrapper active">
        <div class="sidebar-menu">
            <ul class="menu">
                <div class="sidebar-header mb-0">
                    <div class="text-center">
                        <img src="assets/images/logo.png" alt="logo">
                        <h3 class="text-uppercase">Bactriz CRM</h3>
                    </div>
                </div>
                <li class="sidebar-item <?php echo is_page_active('index.php'); ?>">
                    <a href="index.php" class='sidebar-link'>
                        <i data-feather="home" width="30"></i>
                        <span>Dashboard</span>
                    </a>
                </li>

                <?php if (can_user_access($user_id, 'atc_record.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('atc_record.php'); ?>">
                    <a href="atc_record.php" class='sidebar-link'>
                        <i data-feather="clipboard" width="30"></i>
                        <span>ATC</span>
                    </a>
                </li>
                <?php } ?>

                <?php if (can_user_access($user_id, 'customers.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('customers.php'); ?>">
                    <a href="customers.php" class='sidebar-link'>
                        <i data-feather="users" width="30"></i>
                        <span>Customer</span>
                    </a>
                </li>
                <?php } ?>

                <?php if (can_user_access($user_id, 'trucks.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('trucks.php'); ?>">
                    <a href="trucks.php" class='sidebar-link'>
                        <i data-feather="truck" width="30"></i>
                        <span>Truck's</span>
                    </a>
                </li>
                <?php } ?>

                <?php if (can_user_access($user_id, 'drivers.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('drivers.php'); ?>">
                    <a href="drivers.php" class='sidebar-link'>
                        <i data-feather="user" width="30"></i>
                        <span>Drivers</span>
                    </a>
                </li>
                <?php } ?>
                
                <?php if (can_user_access($user_id, 'maintence_record.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('maintence_record.php'); ?>">
                    <a href="maintence_record.php" class='sidebar-link'>
                        <i data-feather="tool" width="30"></i>
                        <span>Expense</span>
                    </a>
                </li>
                <?php } ?>


                <?php if (can_user_access($user_id, 'trip.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('trip.php'); ?>">
                    <a href="trip.php" class='sidebar-link'>
                        <i data-feather="send" width="30"></i>
                        <span>Logistics</span>
                    </a>
                </li>
                <?php } ?>

                <?php if (can_user_access($user_id, 'order.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('order.php'); ?>">
                    <a href="order.php" class='sidebar-link'>
                        <i data-feather="shopping-cart" width="30"></i>
                        <span>Orders</span>
                    </a>
                </li>
                <?php } ?>

                <?php if (can_user_access($user_id, 'fuel_log.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('fuel_log.php'); ?>">
                    <a href="fuel_log.php" class='sidebar-link'>
                        <i data-feather="droplet" width="30"></i>
                        <span>Fuel Logs</span>
                    </a>
                </li>
                <?php } ?>

                <?php if (can_user_access($user_id, 'transactions.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('transactions.php'); ?>">
                    <a href="transactions.php" class='sidebar-link'>
                        <i data-feather="list" width="30"></i>
                        <span>Transactions History</span>
                    </a>
                </li>
                <?php } ?>

                <?php if (can_user_access($user_id, 'account.php')) { ?>
                <li class="sidebar-item <?php echo is_page_active('account.php'); ?>">
                    <a href="account.php" class='sidebar-link'>
                        <i data-feather="users" width="30"></i>
                        <span>User Management</span>
                    </a>
                </li>
                <?php } ?>

                <?php if($_SESSION['user_type'] == 'Admin') { ?>
                <li class="sidebar-item <?php echo is_page_active('assigning_rate.php'); ?>">
                    <a href="assigning_rate.php" class='sidebar-link'>
                        <i data-feather="droplet" width="30"></i>
                        <span>Assigning Rate</span>
                    </a>
                </li>

                <li class="sidebar-item <?php echo is_page_active('reports_analysis.php'); ?>">
                    <a href="reports_analysis.php" class='sidebar-link'>
                        <i data-feather="bar-chart" width="30"></i>
                        <span>Reports & Analysis</span>
                    </a>
                </li>
                <?php } ?>

            </ul>
        </div>
        </div>
</div>
<div id="main">
    <nav class="navbar navbar-header navbar-expand navbar-light">
        <a class="sidebar-toggler" href="#"><span class="navbar-toggler-icon"></span></a>
        <button class="btn navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav d-flex align-items-center navbar-light ms-auto">
                <li class="dropdown nav-icon">
                    <a href="#" data-bs-toggle="dropdown" class="nav-link  dropdown-toggle nav-link-lg nav-link-user">
                        <div class="d-lg-inline-block">
                            <i data-feather="bell"></i>
                            <span class="absolute top-0 right-0 w-2 h-2 bg-red-500 rounded-full"></span>
                        </div>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end dropdown-menu-large">
                        <h6 class='py-2 px-4'>Notifications</h6>
                        <ul class="list-group rounded-none">
                            <li class="list-group-item border-0 align-items-start">
                                <div class="avatar bg-success me-3">
                                    <span class="avatar-content"><i data-feather="shopping-cart"></i></span>
                                </div>
                                <div>
                                    <?php  
                                        // Query to count trips requiring financial setup
                                        $count_query = Querydb("SELECT COUNT(*) as pending_count FROM trips WHERE status = 'Completed' AND (haulage_amount = 0 OR promo_amount = 0 OR incentive_amount = 0)");
                                        $count_data = mysqli_fetch_assoc($count_query);
                                        $pending_total = $count_data['pending_count'];
                                        $countquery = Querydb("SELECT COUNT(*) as pending_count FROM orders WHERE status = 'Pending' ");
                                        $countdata = mysqli_fetch_assoc($countquery);
                                        $pendingtotal = $countdata['pending_count'];
                                     ?>
                                    <h6 class='text-bold'>New Order</h6>
                                    <div class="d-flex align-items-center mb-4">
                                        <?php if ($pendingtotal > 0){ ?>
                                            <a href="order.php" class="btn btn-danger btn-sm rounded-pill shadow-sm">
                                                <i class="bi bi-exclamation-triangle-fill me-1"></i>
                                                <?php echo $pendingtotal; ?> Pending Order
                                            </a>
                                        <?php } else { ?>
                                            <span class="badge bg-light text-black border border-success px-3 py-2 rounded-pill">
                                                <i class="bi bi-check-circle-fill me-1"></i> All Orders are Set
                                            </span>
                                        <?php } ?>
                                    </div>
                                    <?php if ($_SESSION['user_type'] == 'Admin') { ?>
                                    <h6 class='text-bold'></h6>
                                    <div class="d-flex align-items-center mb-4">
                                        <?php if ($pending_total > 0){ ?>
                                            <a href="fuel_log.php?reports_analysis" class="btn btn-danger btn-sm rounded-pill shadow-sm">
                                                <i class="bi bi-exclamation-triangle-fill me-1"></i>
                                                <?php echo $pending_total; ?> Pending Financials
                                            </a>
                                        <?php } else { ?>
                                            <span class="badge bg-light text-success border border-success px-3 py-2 rounded-pill">
                                                <i class="bi bi-check-circle-fill me-1"></i> All Financials Set
                                            </span>
                                        <?php } ?>
                                    </div>
                                    <?php } ?>
                                </div>
                            </li>
                        </ul>
                    </div>
                </li>
                <li class="dropdown">
                    <a href="#" data-bs-toggle="dropdown" class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                        <div class="avatar me-1">
                            <img src="<?php echo !empty($user['profile_img']) ? 'assets/images/avatar/'. $user['profile_img'] : get_avatar($_SESSION['full_name']); ?>"class="rounded-circle" alt="Profile">
                        </div>
                        <div class="d-none d-md-block d-lg-inline-block">Hi, <?php echo $user['last_name']; ?></div>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end">
                        <a class="dropdown-item" href="user_profile.php"><i data-feather="user"></i> Account</a>
                        <a class="dropdown-item" href="user_profile.php"><i data-feather="settings"></i> Settings</a>
                        <div class="dropdown-divider"></div>
                        <button type="submit" class="dropdown-item" id="authorize_sign_out"><i data-feather="log-out"></i> Logout</button>
                    </div>
                </li>
            </ul>
        </div>
    </nav>
            