<?php include 'inc/funtions.php';
if (isset($_SESSION['user_type'])) {
    $user_id = $_SESSION['user_id'];
    $business_id = $_SESSION['business_id'];
    $user = getUserId($user_id);
    $pages_allowed = check_page_access();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    
    <link rel="stylesheet" href="assets/vendors/chartjs/Chart.min.css">
    <link rel="stylesheet" href="assets/vendors/simple-datatables/style.css">
    <link rel="stylesheet" href="assets/vendors/perfect-scrollbar/perfect-scrollbar.css">
    <link rel="stylesheet" href="assets/css/app.css">
    <link rel="shortcut icon" href="assets/images/favicon.png" type="image/x-icon">
</head>
<body>
    <div id="app">
        <?php include('inc/header.php'); ?>            
            <div class="main-content container-fluid">
                <div class="mb-4">
                    <h3>Driver Record</h3>
                    <nav aria-label="breadcrumb" class='breadcrumb-header'>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.php">Dashboard</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Driver Record</li>
                        </ol>
                    </nav>
                </div> 
                <section class="section">
                    <?php
                        // Query to count statuses: 1 = Active, 2 = Suspended, 0 = Unassigned
                        $stats_sql = Querydb("SELECT 
                            COUNT(CASE WHEN is_active = 1 THEN 1 END) as active_count,
                            COUNT(CASE WHEN is_active = 2 THEN 1 END) as deactive_count,
                            COUNT(CASE WHEN is_active = 0 THEN 1 END) as unassigned_count
                            FROM drivers WHERE business_id = '$business_id'");

                        // Fetch the results
                        $stats = mysqli_fetch_assoc($stats_sql); 
                        ?>
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="card shadow-sm border-0 border-start border-success border-4">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="text-uppercase mb-1 small fw-bold text-muted">Active Drivers</h6>
                                            <h2 class="fw-bold mb-0 text-success"><?php echo $stats['active_count'] ?: 0; ?></h2>
                                            <small class="text-muted">On Duty</small>
                                        </div>
                                        <div class="bg-light-success p-3 rounded-circle">
                                            <i class="bi bi-person-check text-success fs-4"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card shadow-sm border-0 border-start border-danger border-4">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="text-uppercase mb-1 small fw-bold text-muted">Suspended</h6>
                                            <h2 class="fw-bold mb-0 text-danger"><?php echo $stats['deactive_count'] ?: 0; ?></h2>
                                            <small class="text-muted">Off Duty / Penalized</small>
                                        </div>
                                        <div class="bg-light-danger p-3 rounded-circle">
                                            <i class="bi bi-person-x text-danger fs-4"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card shadow-sm border-0 border-start border-secondary border-4">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <h6 class="text-uppercase mb-1 small fw-bold text-muted">Unassigned</h6>
                                            <h2 class="fw-bold mb-0 text-secondary"><?php echo $stats['unassigned_count'] ?: 0; ?></h2>
                                            <small class="text-muted">Waiting Assignment</small>
                                        </div>
                                        <div class="bg-light-secondary p-3 rounded-circle">
                                            <i class="bi bi-person-dash text-secondary fs-4"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="">
                            <div class="card">
                                <div class="card-header d-flex justify-content-between align-items-center">
                                    <h4 class="card-title">Driver Record</h4>
                                    <div class="d-flex ">
                                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#adddrivermodal"><i data-feather="plus"></i> Add Driver</button>
                                    </div>
                                </div>
                                <div class="card-body px-0 pb-0">
                                    <div class="table-responsive p-3">
                                        <table class='table table-striped mb-0' id="table1">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Driver NO</th>
                                                    <th>Phone</th>
                                                    <th>License Number</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php 
                                                $count = 1;
                                                $sql = Querydb("SELECT * FROM drivers WHERE business_id = '$business_id' Order by driver_id desc");
                                                    foreach ($sql as $key => $driver) { ?>
                                               <tr>
                                                    <td><?php echo $count; ?></td>
                                                    <td><?php echo $driver['first_name']." ".$driver['last_name']." ".$driver['middle_name']; ?></td>
                                                    <td><?php echo $driver['phone_number']; ?></td>
                                                    <td><?php echo $driver['license_number']; ?></td>
                                                    <td>
                                                        <?php if ($driver['is_active'] == 1): ?>
                                                            <span class="badge bg-success">Active</span>
                                                        <?php elseif ($driver['is_active'] == 2): ?>
                                                            <span class="badge bg-danger">Suspended</span>
                                                        <?php else: ?>
                                                            <span class="badge bg-secondary">Unassign</span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <div class="btn-group">
                                                            <button type="button" class="btn btn-secondary" data-bs-toggle="modal" data-bs-target="#viewdriverModal<?php echo $driver['driver_id']; ?>"><i data-feather="eye"></i> Preview</button>
                                                            <button type="submit" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#editdriverModal<?php echo $driver['driver_id']; ?>"><i data-feather="edit"></i> Edit</button>

                                                            <button type="button" 
                                                                    class="btn <?php echo ($driver['is_active'] == 0 || $driver['is_active'] == 1) ? 'btn-danger' : 'btn-success'; ?> toggle-all-sessions" 
                                                                    data-userid="<?php echo $driver['driver_id']; ?>" 
                                                                    data-currentstatus="<?php echo $driver['is_active']; ?>"
                                                                    title="<?php echo ($driver['is_active'] == 0 || $driver['is_active'] == 1) ? 'Suspend All Roles' : 'Activate All Roles'; ?>">
                                                                <i data-feather="<?php echo ($driver['is_active'] == 0 || $driver['is_active'] == 1) ? 'user-minus' : 'user-check'; ?>"></i> <?php echo ($driver['is_active'] == 0 || $driver['is_active'] == 1) ? 'Suspend' : 'Activate'; ?>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Edit driver Modal -->
                                                <div class="modal fade" id="editdriverModal<?php echo $driver['driver_id']; ?>">
                                                    <div class="modal-dialog modal-dialog-centered modal-lg"> <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title">Edit Driver: <?php echo $driver['first_name']; ?></h4>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                            </div>
                                                            <div class="modal-body row">
                                                                <form id="editDriverForm_<?php echo $count; ?>" class="row g-3" enctype="multipart/form-data">
                                                                    <input type="hidden" name="driver_id" value="<?php echo $driver['driver_id']; ?>">
                                                                    <input type="hidden" name="current_profile_img" value="<?php echo $driver['profile_img']; ?>">
                                                                    <input type="hidden" name="current_license_doc" value="<?php echo $driver['license_doc']; ?>">
                                                                    <input type="hidden" name="action" value="edit_driver">

                                                                    <div class="col-12 text-center">
                                                                        <img id="driver_preview<?php echo $count; ?>" src="assets/images/avatar/<?php echo $driver['profile_img']; ?>" class="img-thumbnail mb-2" style="max-width: 130px; height: 130px; object-fit: cover;">
                                                                        <div class="input-group">
                                                                            <label class="input-group-text">Change Photo</label>
                                                                            <input type="file" class="form-control" name="profilePic" id="DriverProfilePic_<?php echo $count; ?>">
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-md-4">
                                                                        <label class="form-label">First Name</label>
                                                                        <input type="text" class="form-control" name="firstname" value="<?php echo $driver['first_name']; ?>">
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <label class="form-label">Middle Name</label>
                                                                        <input type="text" class="form-control" name="middlename" value="<?php echo $driver['middle_name']; ?>">
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <label class="form-label">Last Name</label>
                                                                        <input type="text" class="form-control" name="lastname" value="<?php echo $driver['last_name']; ?>">
                                                                    </div>

                                                                    <div class="col-md-6">
                                                                        <label class="form-label">Phone NO</label>
                                                                        <input type="text" class="form-control" name="phone" value="<?php echo $driver['phone_number']; ?>">
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <label class="form-label">Driver License Number</label>
                                                                        <input type="text" class="form-control" name="DriverLicence" value="<?php echo $driver['license_number']; ?>">
                                                                    </div>

                                                                    <div class="col-12">
                                                                        <label class="form-label">Update License Document (PDF/Image)</label>
                                                                        <input type="file" class="form-control" name="driverDoc">
                                                                        <small class="text-muted">Current file: <?php echo $driver['license_doc'] ?: 'No document uploaded'; ?></small>
                                                                    </div>

                                                                    <hr class="my-4">
                                                                    <h6 class="fw-bold">Guarantor Information</h6>

                                                                    <div class="col-md-6">
                                                                        <label class="form-label">Guarantor 1 Name</label>
                                                                        <input type="text" class="form-control" name="g1_name" value="<?php echo $driver['g1_name']; ?>">
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <label class="form-label">Guarantor 1 Phone</label>
                                                                        <input type="text" class="form-control" name="g1_phone" value="<?php echo $driver['g1_phone']; ?>">
                                                                    </div>

                                                                    <div class="col-md-6">
                                                                        <label class="form-label">Guarantor 2 Name</label>
                                                                        <input type="text" class="form-control" name="g2_name" value="<?php echo $driver['g2_name']; ?>">
                                                                    </div>
                                                                    <div class="col-md-6">
                                                                        <label class="form-label">Guarantor 2 Phone</label>
                                                                        <input type="text" class="form-control" name="g2_phone" value="<?php echo $driver['g2_phone']; ?>">
                                                                    </div>
                                                                </form>
                                                            </div>

                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                <button type="button" class="btn btn-primary editBtndriver" data-count="<?php echo $count; ?>">Save Changes</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- View driver Modal --> 
                                                <div class="modal fade" id="viewdriverModal<?php echo $driver['driver_id']; ?>" tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog modal-dialog-centered modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h4 class="modal-title">Driver Profile</h4>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="row">
                                                                    <div class="col-md-4 text-center border-end">
                                                                        <img src="assets/images/avatar/<?php echo $driver['profile_img']; ?>" 
                                                                             alt="Profile" class="rounded shadow-sm mb-3" 
                                                                             style="width: 150px; height: 150px; object-fit: cover;">
                                                                        <h5 class="fw-bold"><?php echo $driver['first_name'] . " " . $driver['last_name']; ?></h5>
                                                                        <p class="text-muted small">Driver ID: #DRV-<?php echo $driver['driver_id']; ?></p>
                                                                        
                                                                        <?php if(!empty($driver['license_doc'])): ?>
                                                                            <a href="assets/documents/<?php echo $driver['license_doc']; ?>" 
                                                                               class="btn btn-sm btn-outline-primary w-100 mt-2 glightbox preview-link"
                                                                               title="Driver License Document">
                                                                               <i data-feather="file-text"></i> View License Document
                                                                            </a>
                                                                        <?php else: ?>
                                                                            <span class="badge bg-light text-dark w-100 py-2 mt-2 border">No Document Uploaded</span>
                                                                        <?php endif; ?>
                                                                    </div>

                                                                    <div class="col-md-8">
                                                                        <h6 class="text-primary text-uppercase small fw-bold mb-3">General Information</h6>
                                                                        <div class="row mb-2">
                                                                            <div class="col-sm-5 text-muted">Middle Name:</div>
                                                                            <div class="col-sm-7 fw-bold"><?php echo $driver['middle_name'] ?: 'N/A'; ?></div>
                                                                        </div>
                                                                        <div class="row mb-2">
                                                                            <div class="col-sm-5 text-muted">License Number:</div>
                                                                            <div class="col-sm-7 fw-bold"><?php echo $driver['license_number']; ?></div>
                                                                        </div>
                                                                        <div class="row mb-4">
                                                                            <div class="col-sm-5 text-muted">Phone Number:</div>
                                                                            <div class="col-sm-7 fw-bold"><?php echo $driver['phone_number']; ?></div>
                                                                        </div>

                                                                        <hr>

                                                                        <h6 class="text-primary text-uppercase small fw-bold mb-3">Guarantor References</h6>
                                                                        <div class="row g-3">
                                                                            <div class="col-sm-6">
                                                                                <div class="p-2 border rounded bg-light">
                                                                                    <small class="d-block text-muted">Guarantor 1</small>
                                                                                    <strong><?php echo $driver['g1_name'] ?: 'Not Provided'; ?></strong>
                                                                                    <div class="small text-primary"><?php echo $driver['g1_phone']; ?></div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-sm-6">
                                                                                <div class="p-2 border rounded bg-light">
                                                                                    <small class="d-block text-muted">Guarantor 2</small>
                                                                                    <strong><?php echo $driver['g2_name'] ?: 'Not Provided'; ?></strong>
                                                                                    <div class="small text-primary"><?php echo $driver['g2_phone']; ?></div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php $count++; } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>

            </div>
<?php  include('inc/footer.php'); 
} else {
    header('Location: pages-error-404.html');
    exit;
}?>
