<?php
 include 'inc/function.php';
$order_id = $_GET['id'];

// Fetch order and user details
$sql = Querydb("SELECT orders.*, users.first_name, users.address FROM orders 
        JOIN users ON users.user_id = 1 
        WHERE orders.order_id = '$order_id'");
$order = mysqli_fetch_assoc($sql);

if (!$order) { die("Order not found."); }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Receipt - <?php echo $order['order_id']; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #f8f9fa; font-family: 'Inter', sans-serif; }
        .receipt-card { max-width: 800px; margin: 40px auto; background: white; padding: 50px; border-radius: 0; box-shadow: 0 0 20px rgba(0,0,0,0.05); }
        .logo-text { font-size: 24px; font-weight: 800; color: #0d6efd; letter-spacing: -1px; }
        @media print { 
            .no-print { display: none; }
            .receipt-card { box-shadow: none; margin: 0; width: 100%; }
        }
    </style>
</head>
<body>

<div class="container no-print text-center mt-4">
    <button class="btn btn-dark rounded-pill px-4" onclick="window.print()">
        <i class="fas fa-print me-2"></i>Print or Save as PDF
    </button>
</div>

<div class="receipt-card">
    <div class="d-flex justify-content-between mb-5">
        <div>
            <div class="logo-text">BACTRIZ</div>
            <p class="text-muted small">Industrial Logistics & Supply<br>Lagos, Nigeria</p>
        </div>
        <div class="text-end">
            <h4 class="fw-bold text-uppercase">Tax Invoice</h4>
            <p class="mb-0 small">Order ID: <strong><?php echo $order['order_id']; ?></strong></p>
            <p class="small">Date: <?php echo date('d M, Y', strtotime($order['order_date'])); ?></p>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-6">
            <p class="text-muted small mb-1">BILL TO:</p>
            <h6 class="fw-bold mb-1"><?php echo $order['first_name']; ?></h6>
            <p class="small text-muted"><?php echo $order['address']; ?></p>
        </div>
    </div>

    <table class="table table-borderless border-top">
        <thead class="bg-light">
            <tr>
                <th class="small py-3">DESCRIPTION</th>
                <th class="small py-3 text-center">QTY</th>
                <th class="small py-3 text-end">TOTAL</th>
            </tr>
        </thead>
        <tbody>
            <tr class="border-bottom">
                <td class="py-4">
                    <span class="fw-bold"><?php echo $order['product_name']; ?></span><br>
                    <small class="text-muted">Standard Delivery - Industrial Grade</small>
                </td>
                <td class="py-4 text-center"><?php echo $order['quantity']; ?></td>
                <td class="py-4 text-end fw-bold">₦<?php echo number_format($order['price'], 2); ?></td>
            </tr>
        </tbody>
    </table>

    <div class="row justify-content-end mt-4">
        <div class="col-5">
            <div class="d-flex justify-content-between mb-2">
                <span class="small text-muted">Subtotal:</span>
                <span class="small fw-bold">₦<?php echo number_format($order['price'], 2); ?></span>
            </div>
            <div class="d-flex justify-content-between mb-2">
                <span class="small text-muted">VAT (7.5%):</span>
                <span class="small fw-bold">₦0.00</span> 
            </div>
            <hr>
            <div class="d-flex justify-content-between">
                <span class="fw-bold">Grand Total:</span>
                <span class="h5 fw-bold text-primary">₦<?php echo number_format($order['price'], 2); ?></span>
            </div>
        </div>
    </div>

    <div class="mt-5 pt-5 text-center">
        <p class="small text-muted">Thank you for choosing Bactriz. This is a computer-generated receipt.</p>
        <div class="badge bg-success-subtle text-success rounded-pill px-3 py-2">PAID IN FULL</div>
    </div>
</div>

</body>
</html>