function showPage(id) {
    document.querySelectorAll('.page-section').forEach(p => p.classList.remove('active'));
    document.getElementById(id).classList.add('active');
}

let table1 = document.querySelector('#table1');
if (table1) {
    let dataTable = new simpleDatatables.DataTable(table1);    
}



function exportToExcel() {
    const from = $('#state-from').val();
    const to = $('#state-to').val();

    if (!from || !to) {
        Swal.fire("Selection Required", "Please select a date range first.", "info");
        return;
    }

    // Redirect to the export script with parameters
    window.location.href = `?from=${from}&to=${to}`;
}

// Preview image before upload
$("#profile_img").change(function() {
    if (this.files && this.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            // Assuming your profile image tag has the ID 'avatarPreview'
            $('#avatarPreview').attr('src', e.target.result);
        }
        reader.readAsDataURL(this.files[0]);
    }
});


function previewDriver(orderId) {
    $('#trackingModal').modal('show');
    $('#trackingDetails').html('<div class="text-center py-5"><div class="spinner-border text-primary"></div></div>');

    $.ajax({
        url: 'inc/code_query.php',
        type: 'POST',
        data: {
            action: 'get_tracking_info',
            order_id: orderId
        },
        success: function(response) {
            // response will be the HTML snippet of driver info
            $('#trackingDetails').html(response);
        },
        error: function() {
            $('#trackingDetails').html('<p class="text-danger">Failed to load tracking info.</p>');
        }
    });
}
