<?php 
include '../inc/funtions.php';

if (isset($_SESSION['user_type']) && $_SESSION['user_type'] == 'Customer') {
    $user_id = $_SESSION['user_id'];
    $business_id = $_SESSION['business_id'];
    $sql = Querydb("SELECT * FROM customers WHERE customer_id = '$user_id' AND business_id = '$business_id'");
                $sql_check = mysqli_fetch_assoc($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bactriz Mobile-First Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="../assets/vendors/simple-datatables/style.css">
    <link rel="stylesheet" type="text/css" href="../assets/vendors/select2/select2.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="shortcut icon" href="../assets/images/favicon.png" type="image/x-icon">
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <nav class="col-md-3 col-lg-2 sidebar p-0">
            <div class="p-4"><h4 class="fw-bold text-primary">BACTRIZ</h4></div>
            <div class="list-group list-group-flush mt-2">
                <button onclick="showPage('dashboard-view')" class="list-group-item list-group-item-action border-0 py-3 px-4"><i class="fas fa-home me-3"></i>Dashboard</button>
                <button onclick="showPage('transaction-view')" class="list-group-item list-group-item-action border-0 py-3 px-4"><i class="fas fa-exchange-alt me-3"></i>Transaction History</button>
                <button onclick="showPage('order-history-view')" class="list-group-item list-group-item-action border-0 py-3 px-4"><i class="fas fa-box me-3"></i>Order History</button>
                
                <button onclick="showPage('statement-view')" class="list-group-item list-group-item-action border-0 py-3 px-4"><i class="fas fa-file-download me-3"></i>Statements</button>
            </div>
        </nav>

        <main class="col-lg-10 main-content">
            <header class="flex justify-between items-center mb-8">
                <div>
                    <h2 class="text-xl font-semibold text-gray-800 text-uppercase">Hi, <?php echo $_SESSION['full_name']; ?></h2>
                    <p class="text-sm text-gray-500"><?php echo date('F l Y') ?></p>
                </div>
                <div class="flex items-center space-x-4">
                    <button class="relative p-2 text-gray-400 hover:text-gray-600" id="authorize_sign_out">
                        <i class="fas fa-sign-out text-xl"></i>
                    </button>
                    <button class="relative p-2 text-gray-400 hover:text-gray-600">
                        <i class="fas fa-bell text-xl"></i>
                        <span class="absolute top-0 right-0 w-2 h-2 bg-red-500 rounded-full"></span>
                    </button>
                    <div onclick="showPage('profile-view')" class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-600 font-bold">
                        <img src="<?php echo !empty($sql_check['profile_img']) ? 'img/'.$sql_check['profile_img'] : get_avatar($_SESSION['full_name']); ?>"class="rounded-circle" alt="Profile"> 
                    </div>
                </div>
            </header>
            <div id="dashboard-view" class="page-section active">
                
                <?php
            // Assuming $user_id is stored in the session
            $user_id = $_SESSION['user_id'];

            // Fetch the latest customer data
            $query = "SELECT wallet_balance, customer_id FROM customers WHERE customer_id = '$user_id'";
            $result = $conn->query($query);
            $customer = $result->fetch_assoc();

            // Format the balance for display
            $display_balance = number_format($customer['wallet_balance'], 2);
            $display_id = "BAC-" . str_pad($customer['customer_id'], 4, '0', STR_PAD_LEFT);
            ?>

            <div class="banking-card rounded-3xl p-8 text-white shadow-xl mb-8">
                <div class="flex justify-between items-start">
                    <div>
                        <p class="text-blue-100 text-sm opacity-80">Total Account Balance</p>
                        <h3 class="text-4xl font-bold mt-1">₦ <?php echo $display_balance; ?></h3>
                    </div>
                    <i class="fas fa-wallet text-3xl opacity-50"></i>
                </div>
                <div class="mt-8 flex space-x-8">
                    <div>
                        <p class="text-xs text-blue-100 opacity-70 uppercase">Account ID</p>
                        <p class="font-mono"><?php echo $display_id; ?></p>
                    </div>
                    <div>
                        <p class="text-xs text-blue-100 opacity-70 uppercase">Status</p>
                        <p class="flex items-center">
                            <span class="w-2 h-2 bg-green-400 rounded-full mr-2"></span> 
                            Active
                        </p>
                    </div>
                </div>
            </div>

            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-8">
                <button class="flex flex-col items-center p-4 bg-white rounded-2xl shadow-sm hover:shadow-md transition-shadow border border-gray-100">
                    <div class="w-12 h-12 bg-green-100 text-green-600 rounded-full flex items-center justify-center mb-2" onclick="showPage('topup-view')">
                        <i class="fas fa-plus"></i>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Top Up</span>
                </button>
                <button class="flex flex-col items-center p-4 bg-white rounded-2xl shadow-sm hover:shadow-md transition-shadow border border-gray-100" onclick="showPage('order-view')">
                    <div class="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mb-2">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                    <span class="text-sm font-medium text-gray-700">New Order</span>
                </button>
                <button class="flex flex-col items-center p-4 bg-white rounded-2xl shadow-sm hover:shadow-md transition-shadow border border-gray-100">
                    <div class="w-12 h-12 bg-purple-100 text-purple-600 rounded-full flex items-center justify-center mb-2" onclick="showPage('statement-view')">
                        <i class="fas fa-file-pdf"></i>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Statement</span>
                </button>
                <butto]n class="flex flex-col items-center p-4 bg-white rounded-2xl shadow-sm hover:shadow-md transition-shadow border border-gray-100">
                    <div class="w-12 h-12 bg-orange-100 text-orange-600 rounded-full flex items-center justify-center mb-2" onclick="showPage('order-history-view')">
                        <i class="fas fa-truck"></i>
                    </div>
                    <span class="text-sm font-medium text-gray-700">Track Trip</span>
                </button>
            </div>

            <div class="bg-white rounded-2xl shadow-sm border border-gray-100">
                <div class="p-6 border-b border-gray-50 flex justify-between items-center">
                    <h3 class="font-bold text-gray-800">Recent Transactions</h3>
                    <a href="#" onclick="showPage('transaction-view')" class="text-blue-600 text-sm font-medium">View All</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="w-full text-left">
                        <thead>
                            <tr class="text-gray-400 text-xs uppercase tracking-wider">
                                <th class="px-6 py-4">Description</th>
                                <th class="px-6 py-4">Date</th>
                                <th class="px-6 py-4">Amount</th>
                                <th class="px-6 py-4">Status</th>
                            </tr>
                        </thead>
                        <?php
                        // Assuming $conn is your database connection and $user_id is from session
                        $sql = "SELECT * FROM transactions WHERE customer_id = '$user_id' ORDER BY created_at DESC LIMIT 5";
                        $result = $conn->query($sql);
                        ?>

                        <tbody class="divide-y divide-gray-50">
                            <?php if ($result->num_rows > 0): ?>
                                <?php while($row = $result->fetch_assoc()): 
                                    // Dynamic logic for colors and icons
                                    $is_credit = ($row['type'] == 'credit');
                                    $bg_color = $is_credit ? 'bg-green-50' : 'bg-red-50';
                                    $icon_color = $is_credit ? 'text-green-500' : 'text-red-500';
                                    $icon = $is_credit ? 'fa-arrow-down' : 'fa-arrow-up';
                                    $amount_color = $is_credit ? 'text-green-500' : 'text-red-500';
                                    $prefix = $is_credit ? '+' : '-';
                                    
                                    // Map status to badge colors
                                    $status = $row['transaction_status'] ?? 'Successful';
                                    $badge_class = ($status == 'Successful') 
                                        ? 'bg-green-100 text-green-700' 
                                        : (($status == 'Pending') 
                                            ? 'bg-yellow-100 text-yellow-700' 
                                            : 'bg-red-500 text-white');
                                ?>
                                <tr>
                                    <td class="px-6 py-4">
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 <?php echo $bg_color; ?> <?php echo $icon_color; ?> rounded flex items-center justify-center mr-3">
                                                <i class="fas <?php echo $icon; ?> text-xs"></i>
                                            </div>
                                            <span class="font-medium text-gray-700">
                                                <?php echo htmlspecialchars($row['description']); ?>
                                            </span>
                                        </div>
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-500">
                                        <?php echo date('M d, Y', strtotime($row['created_at'])); ?>
                                    </td>
                                    <td class="px-6 py-4 font-semibold <?php echo $amount_color; ?>">
                                        <?php echo $prefix; ?> ₦ <?php echo number_format(abs($row['amount']), 0); ?>
                                    </td>
                                    <td class="px-6 py-4">
                                        <span class="px-3 py-1 rounded-full text-xs <?php echo $badge_class; ?>">
                                            <?php echo $status; ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="4" class="px-6 py-10 text-center text-gray-400">No recent transactions.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            </div>

            <div id="topup-view" class="page-section">
                <h4 class="fw-bold mb-4">Load Wallet</h4>
                <form id="topupForm" enctype="multipart/form-data">
                    <div class="card border-0 shadow-sm rounded-4 p-4">
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label small fw-bold">Amount to Add</label>
                                <input type="number" id="t-amount" name="amount" class="form-control bg-light border-0 p-3" placeholder="₦ 0.00" required>
                            </div>
                            <div class="col-md-6 mb-4">
                                <label class="form-label small fw-bold">Bank Sent TO</label>
                                <input type="text" id="t-bank" name="bank" class="form-control border-0 bg-light p-3" placeholder="e.g. MONIEPOINT" required>
                            </div>
                            <div class="col-md-6 mb-4">
                                <label class="form-label small fw-bold">Reference Number (Optional)</label>
                                <input type="text" id="t-ref" name="reference" class="form-control border-0 bg-light p-3" placeholder="Reference Number">
                            </div>
                            <div class="col-md-6 mb-4">
                                <label class="form-label small fw-bold">Receipt Image (Optional)</label>
                                <input type="file" id="t-receipt" name="receipt" class="form-control border-0 bg-light p-3" accept="image/*">
                            </div>
                            <div class="mb-4">
                                <label class="form-label small fw-bold">Description / Note</label>
                                <textarea id="t-desc" name="description" rows="3" class="form-control border-0 bg-light p-3"></textarea>
                            </div>                        
                        </div>

                        <button type="button" class="btn btn-primary btn-lg w-100 rounded-pill" id="Topup_submit">Confirm Deposit</button>
                    </div>
                </form>
            </div>

            <div id="order-view" class="page-section">
                <h4 class="fw-bold mb-4">Create Requisition</h4>
                <div class="card border-0 shadow-sm rounded-4 p-4">
                    <div class="row">
                        <div class="col-md-12 mb-3">
                            <label class="form-label small fw-bold">Item</label>
                            <input type="text" id="o-item" class="form-select border-0 bg-light p-3" placeholder="Bulk Cement (Dangote)" required>
                        </div>
                        <div class="mb-4">
                            <label class="form-label small fw-bold">QTY/UNIT</label>
                            <input type="number" id="o-unit" max="900" min="1" class="form-control border-0 bg-light p-3" placeholder="₦ 0.00" required>
                        </div>
                        <div class="mb-4">
                            <label class="form-label small fw-bold">Location</label>
                            <textarea id="o-location" rows="3" class="form-control border-0 bg-light p-3" required ></textarea>
                        </div>
                        <button class="btn btn-primary btn-lg w-100 rounded-pill" id="o-submit">Submit</button>
                    </div>                        
                </div>
            </div>
            <div id="transaction-view" class="page-section">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="fw-bold">Financial Transactions</h4>
                    <button class="btn btn-outline-primary btn-sm rounded-pill" onclick="exportToExcel()">Export CSV</button>
                </div>
                <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                    <div id="financial-list" class="bg-white">
                        <div class="table-responsive">
                            <table class="table table-hover align-middle mb-0" id="table1">
                                <thead class="bg-light">
                                    <tr>
                                        <th class="px-4 py-3 small text-muted">DATE</th>
                                        <th class="px-4 py-3 small text-muted">TXN ID</th>
                                        <th class="px-4 py-3 small text-muted">DESCRIPTION</th>
                                        <th class="px-4 py-3 small text-muted">TYPE</th>
                                        <th class="px-4 py-3 small text-muted">STATUS</th>
                                        <th class="px-4 py-3 small text-muted text-center">AMOUNT</th>
                                        <th class="px-4 py-3 small text-muted">BAL BEFORE</th>
                                        <th class="px-4 py-3 small text-muted">BAL AFTER</th>
                                    </tr>
                                </thead>
                                <?php
                                // Assuming $conn is your database connection and $user_id is from session
                                $sql = "SELECT * FROM transactions WHERE customer_id = '$user_id' ORDER BY created_at DESC";
                                $result = $conn->query($sql);
                                ?>
                                <tbody>
                                    <?php 

                                    while($row = mysqli_fetch_assoc($result)) { 
                                        $is_debit = (float)$row['amount'] < 0;
                                        // Map status to badge colors
                                    $status = $row['transaction_status'] ?? 'Successful';
                                    $badge_class = ($status == 'Successful') 
                                    ? 'bg-green-100 text-green-700' 
                                    : (($status == 'Pending') 
                                        ? 'bg-yellow-100 text-yellow-700' 
                                        : 'bg-red-500 text-white');
                                    $is_credit = ($row['type'] == 'credit');
                                    $bg_color = $is_credit ? 'bg-green-500' : 'bg-red-500';

                                    ?>
                                    <tr class="text-center">
                                        <td class="px-4 py-3 small"><?php echo date('M d, H:i', strtotime($row['created_at'])); ?></td>
                                        <td class="px-4 py-3 small fw-bold text-primary"><?php echo $row['trans_id']; ?></td>
                                        <td class="px-4 py-3 small text-wrap" style="max-width: 200px;"><?php echo $row['description']; ?></td>
                                        <td class="px-6 py-4">
                                            <span class="px-3 py-1 rounded-full text-white text-xs <?php echo $bg_color; ?>">
                                                <?php echo $row['type']; ?>
                                            </span>
                                        </td>
                                        <td class="px-6 py-4">
                                            <span class="px-3 py-1 rounded-full text-xs <?php echo $badge_class; ?>">
                                                <?php echo $status; ?>
                                            </span>
                                        </td>
                                        <td class="px-4 py-3 text-center fw-bold <?php echo $is_debit ? 'text-danger' : 'text-success'; ?>">
                                            <?php echo $is_debit ? '-' : '+'; ?>₦<?php echo number_format(abs($row['amount']), 2); ?>
                                        </td>
                                        <td class="px-4 py-3 small fw-bold text-muted">₦<?php echo number_format($row['bal_before'], 2); ?></td>
                                        <td class="px-4 py-3 small fw-bold text-dark">₦<?php echo number_format($row['bal_after'], 2); ?></td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div id="order-history-view" class="page-section">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="fw-bold">Order History</h4>
                </div>
                
                <?php
                $sql = Querydb("SELECT * FROM orders WHERE customer_id = $user_id AND business_id = '$business_id' ORDER BY order_date DESC");
                ?>

                <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                    <div class="table-responsive p-4">
                        <table class="table table-hover data-table mb-0" id="table1">
                            <thead class="bg-light">
                                <tr>
                                    <th class="border-0 px-4 py-3 small text-muted">ORDER ID</th>
                                    <th class="border-0 px-4 py-3 small text-muted">PRODUCT</th>
                                    <th class="border-0 px-4 py-3 small text-muted text-center">STATUS</th>
                                    <th class="border-0 px-4 py-3 small text-muted">LOCATION</th>
                                    <th class="border-0 px-4 py-3 small text-muted text-end">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (mysqli_num_rows($sql) > 0) {
                                    while($row = mysqli_fetch_assoc($sql)) { ?>
                                        <tr class="align-middle">
                                            <td class="px-4 py-3 fw-bold small text-primary">
                                                <?php echo htmlspecialchars($row['order_id']); ?>
                                            </td>
                                            <td class="px-4 py-3">
                                                <div class="small fw-bold"><?php echo htmlspecialchars($row['product_name']); ?></div>
                                                <div class="text-muted" style="font-size: 11px;">
                                                    <?php echo htmlspecialchars($row['quantity']); ?> • <?php echo date('M d, Y', strtotime($row['order_date'])); ?>
                                                </div>
                                            </td>
                                            <td class="px-4 py-3 text-center">
                                                <span class="badge bg-<?php echo $row['varify_code'] ?>-subtle text-<?php echo $row['varify_code'] ?> rounded-pill">
                                                    <?php echo $row['status']; ?>
                                                </span>
                                            </td>
                                            <td class="px-4 py-3">
                                                <div class="small fw-bold"><?php echo htmlspecialchars($row['location']); ?></div>
                                            </td>
                                            <td class="px-4 py-3 text-end">
                                                <div class="d-flex justify-content-end gap-2">
                                                    <!-- <a href="receipt.php?id=<?php echo $row['order_id']; ?>" class="btn btn-light btn-sm rounded-circle shadow-sm">
                                                        <i class="fas fa-file-invoice text-primary"></i>
                                                    </a> -->
                                                    <button class="btn btn-primary btn-sm rounded-pill px-3 fw-bold" 
                                                            onclick="previewDriver('<?php echo $row['order_id']; ?>')">
                                                        <i class="fas fa-truck me-1"></i> Track
                                                    </button>
                                                    <?php if($row['status'] == 'In Transit') { ?>
                                                        <button class="btn btn-success btn-sm rounded-pill px-3 fw-bold" 
                                                                id="confirmDelivery_<?php echo $row['order_id']; ?>">
                                                            Confirm Received
                                                        </button>
                                                    <?php } ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php }; 
                                     } else { ?>
                                    <tr>
                                        <td colspan="4" class="text-center py-5 text-muted">No orders found.</td>
                                    </tr>
                                <?php }; ?>
                                    <div class="modal fade" id="trackingModal" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content border-0 shadow rounded-4">
                                                <div class="modal-header border-0">
                                                    <h5 class="modal-title fw-bold">Shipment Details</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body" id="trackingDetails">
                                                    <div class="text-center py-4">
                                                        <div class="spinner-border text-primary" role="status"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- <div id="order-history-view" class="page-section">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="fw-bold">Order History</h4>
                </div>
                
                <?php
                // Fetch orders for the logged-in user
                $sql = Querydb("SELECT * FROM orders WHERE customer_id = '$user_id' ORDER BY order_date DESC");
                ?>

                <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                    <div class="table-responsive p-4">
                        <table class="table table-hover data-table mb-0" id="table1">
                            <thead class="bg-light">
                                <tr>
                                    <th class="border-0 px-4 py-3 small text-muted">ORDER ID</th>
                                    <th class="border-0 px-4 py-3 small text-muted">PRODUCT</th>
                                    <th class="border-0 px-4 py-3 small text-muted text-center">STATUS</th>
                                    <th class="border-0 px-4 py-3 small text-muted">LOCATION</th>
                                    <th class="border-0 px-4 py-3 small text-muted text-end">ACTION</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (mysqli_num_rows($sql) > 0) {
                                    while($row = mysqli_fetch_assoc($sql)) { 
                                        // Determine Badge Color based on Status
                                        $status = $row['status'];
                                        $badge_class = "bg-secondary"; // Default
                                        if ($status == 'Pending') $badge_class = "bg-warning text-dark";
                                        if ($status == 'In Transit') $badge_class = "bg-info text-white";
                                        if ($status == 'Completed' || $status == 'Delivered') $badge_class = "bg-success text-white";
                                    ?>
                                    <tr class="align-middle">
                                        <td class="px-4 py-3 fw-bold small text-primary">
                                            #<?php echo htmlspecialchars($row['order_id']); ?>
                                        </td>
                                        <td class="px-4 py-3">
                                            <div class="small fw-bold"><?php echo htmlspecialchars($row['product_name']); ?></div>
                                            <div class="text-muted" style="font-size: 11px;">
                                                <?php echo htmlspecialchars($row['quantity']); ?> • <?php echo date('M d, Y', strtotime($row['order_date'])); ?>
                                            </div>
                                        </td>
                                        <td class="px-4 py-3 text-center">
                                            <span class="badge <?php echo $badge_class; ?> rounded-pill px-3">
                                                <?php echo $status; ?>
                                            </span>
                                        </td>
                                        <td class="px-4 py-3">
                                            <div class="text-muted small">
                                                <i class="fas fa-map-marker-alt text-danger me-1"></i>
                                                <?php echo htmlspecialchars($row['location']); ?>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="">
                                                <a href="receipt.php?id=<?php echo $row['order_id']; ?>" class="btn btn-light btn-sm rounded-circle shadow-sm">
                                                    <i class="fas fa-file-invoice text-primary"></i>
                                                </a>
                                                
                                                <?php if($status == 'In Transit') { ?>
                                                    <button class="btn btn-success btn-sm rounded-pill px-3 fw-bold" 
                                                            id="confirmDelivery_<?php echo $row['order_id']; ?>">
                                                        Confirm Received
                                                    </button>
                                                <?php } ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php } 
                                } else { ?>
                                    <tr>
                                        <td colspan="5" class="text-center py-5 text-muted">No orders found.</td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div> -->

            <div id="profile-view" class="page-section">
                <h4 class="fw-bold mb-4">Account Settings</h4>
                <div class="row g-4">
                    <div class="col-md-4">
                        <div class="card border-0 shadow-sm rounded-4 p-4 text-center">
                            <div class="position-relative d-inline-block mx-auto mb-3">
                                <img src="<?php echo !empty($sql_check['profile_img']) ? 'img/'.$sql_check['profile_img'] : get_avatar($_SESSION['full_name']); ?>"class="rounded-circle" id="avatarPreview" alt="Profile" style="width: 200px; height: 200px;">
                                <button class="btn btn-sm btn-primary position-absolute bottom-0 end-0 rounded-circle border-white">
                                    <label for="profile_img"><i class="fas fa-camera"></i></label>

                                </button>
                            </div>
                            <h5 class="fw-bold mb-1"><?php echo $_SESSION['full_name']; ?></h5>
                            <p class="text-muted small mb-3">Email: <?php echo $sql_check['email'] ?></p>
                            <span class="badge bg-success-subtle text-success rounded-pill px-3">
                                <i class="fas fa-check-circle me-1"></i>Verified Business
                            </span>
                        </div>
                    </div>

                    <div class="col-md-8">
                        <div class="card border-0 shadow-sm rounded-4 p-4">
                            <ul class="nav nav-pills mb-4 bg-light p-1 rounded-pill" id="profileTabs" role="tablist">
                                <li class="nav-item flex-fill">
                                    <button class="nav-link active rounded-pill w-100 fw-bold" data-bs-toggle="pill" data-bs-target="#tab-info">Personal & Kin</button>
                                </li>
                                <li class="nav-item flex-fill">
                                    <button class="nav-link rounded-pill w-100 fw-bold" data-bs-toggle="pill" data-bs-target="#tab-security">Security</button>
                                </li>
                            </ul>

                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="tab-info">
                                    <form id="profileForm">
                                        <h6 class="fw-bold text-primary mb-3">Basic Information</h6>
                                        <div class="row g-3 mb-4">
                                            <div class="col-md-6">
                                                <input type="file" name="profile_img" id="profile_img" class="d-none">
                                                <input type="hidden" name="profile_img" id="pre_profile_img" value="<?php echo $sql_check['profile_img']; ?>">
                                                <label class="form-label small fw-bold text-muted">FULL NAME</label>
                                                <input type="text" name="full-name" class="form-control bg-light border-0" value="<?php echo $_SESSION['full_name']; ?>">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label small fw-bold text-muted">PHONE NUMBER</label>
                                                <input type="text" name="phone-no" class="form-control bg-light border-0" value="<?php echo $sql_check['phone'] ?>">
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label small fw-bold text-muted">EMAIL ADDRESS</label>
                                                <input type="email" name="email" class="form-control bg-light border-0" value="<?php echo $sql_check['email'] ?>">
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label small fw-bold text-muted">ADDRESS</label>
                                                <textarea type="text" name="address" class="form-control bg-light border-0"><?php echo $sql_check['address'] ?></textarea>
                                            </div>
                                            <!-- <div class="col-md-6">
                                                <label class="form-label small fw-bold text-muted">COMPANY NAME</label>
                                                <input type="text" name="" class="form-control bg-light border-0" value="Doe Logistics Ltd">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label small fw-bold text-muted">BUSINESS RC NUMBER</label>
                                                <input type="text" name="" class="form-control bg-light border-0" placeholder="RC-1234567">
                                            </div> -->
                                        </div>

                                        <h6 class="fw-bold text-primary mb-3">Next of Kin Details</h6>
                                        <div class="row g-3">
                                            <div class="col-md-6">
                                                <label class="form-label small fw-bold text-muted">KIN FULL NAME</label>
                                                <input type="text" name="kin-name" class="form-control bg-light border-0" value="<?php echo $sql_check['kin_full_name'] ?>" placeholder="Lukman Ayomide" required>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label small fw-bold text-muted">RELATIONSHIP</label>
                                                <select class="form-select bg-light border-0" name="kin-relation" required>
                                                    <option disabled>Select Relationship</option>
                                                    <option value="Spouse" <?php echo ($sql_check['kin_relation'] == 'Spouse') ? 'selected' : ''; ?>>Spouse</option>
                                                    <option value="Parent" <?php echo ($sql_check['kin_relation'] == 'Parent') ? 'selected' : ''; ?>>Parent</option>
                                                    <option value="Sibling" <?php echo ($sql_check['kin_relation'] == 'Sibling') ? 'selected' : ''; ?>>Sibling</option>
                                                    <option value="Other" <?php echo ($sql_check['kin_relation'] == 'Other') ? 'selected' : ''; ?>>Other</option>
                                                </select>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label small fw-bold text-muted">PHONE NUMBER</label>
                                                <input type="text" name="kin-phone" class="form-control bg-light border-0" value="<?php echo $sql_check['kin_phone_no'] ?>" placeholder="+234..." required>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label small fw-bold text-muted">EMAIL ADDRESS</label>
                                                <input type="email" name="kin-email" class="form-control bg-light border-0" value="<?php echo $sql_check['kin_email'] ?>" placeholder="email@gmail.com" required>
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label small fw-bold text-muted">ADDRESS</label>
                                                <input type="text" name="kin-address" class="form-control bg-light border-0" value="<?php echo $sql_check['kin_address'] ?>" placeholder="London Street Area 3 ..." required>
                                            </div>
                                        </div>

                                        <hr class="my-4">
                                        <button type="button" id="updateBtn" onclick="saveProfile()" class="btn btn-primary px-5 rounded-pill fw-bold w-100">
                                            <span id="btnSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                                            <span id="btnText">Update Profile</span>
                                        </button>
                                    </form>
                                </div>

                                <div class="tab-pane fade" id="tab-security">
                                    <form id="passwordForm">
                                        <h6 class="fw-bold text-primary mb-3">Change Password</h6>
                                        <div class="mb-3">
                                            <label class="form-label small fw-bold text-muted">CURRENT PASSWORD</label>
                                            <input type="password" id="curr-pass" class="form-control bg-light border-0" placeholder="••••••••">
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label small fw-bold text-muted">NEW PASSWORD</label>
                                            <input type="password" id="new-pass" class="form-control bg-light border-0" placeholder="Minimum 8 characters">
                                        </div>
                                        <div class="mb-4">
                                            <label class="form-label small fw-bold text-muted">CONFIRM NEW PASSWORD</label>
                                            <input type="password" id="confirm-pass" class="form-control bg-light border-0" placeholder="Confirm new password">
                                        </div>
                                        
                                        <div class="alert alert-info border-0 rounded-4 small">
                                            <i class="fas fa-info-circle me-2"></i> Password must contain at least one uppercase letter and one number.
                                        </div>

                                        <button type="button" class="btn btn-dark px-5 rounded-pill fw-bold w-100" onclick="updatePassword()">Update Password</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="statement-view" class="page-section">
                <h4 class="fw-bold mb-4">Account Statement</h4>
                
                <div class="card border-0 shadow-sm rounded-4 p-4 mb-4">
                    <div class="row g-3 align-items-end">
                        <div class="col-md-4">
                            <label class="form-label small fw-bold text-muted">START DATE</label>
                            <input type="date" id="state-from" class="form-control border-0 bg-light p-3">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label small fw-bold text-muted">END DATE</label>
                            <input type="date" id="state-to" class="form-control border-0 bg-light p-3">
                        </div>
                        <div class="col-md-4">
                            <button class="btn btn-primary w-100 py-3 rounded-pill fw-bold shadow-sm" onclick="generatePreview()">
                                Generate Report
                            </button>
                        </div>
                    </div>
                </div>

                <div id="statement-preview" class="d-none">
                    
                    <div class="row g-3 mb-4">
                        <div class="col-md-4">
                            <div class="card border-0 shadow-sm rounded-4 p-3 bg-success text-white">
                                <small class="opacity-75 fw-bold">TOTAL INFLOW (CREDITS)</small>
                                <h4 class="fw-bold mb-0" id="sum-inflow">₦0.00</h4>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-0 shadow-sm rounded-4 p-3 bg-danger text-white">
                                <small class="opacity-75 fw-bold">TOTAL OUTFLOW (DEBITS)</small>
                                <h4 class="fw-bold mb-0" id="sum-outflow">₦0.00</h4>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card border-0 shadow-sm rounded-4 p-3 bg-white border-start border-primary border-4">
                                <small class="text-muted fw-bold">NET PERIOD BALANCE</small>
                                <h4 class="fw-bold mb-0 text-primary" id="sum-net">₦0.00</h4>
                            </div>
                        </div>
                    </div>

                    <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
                        <div class="card-header bg-white border-0 p-4 d-flex justify-content-between align-items-center">
                            <h6 class="fw-bold mb-0 text-muted">TRANSACTION BREAKDOWN</h6>
                            <div class="d-flex gap-2">
                                <button class="btn btn-outline-success btn-sm rounded-pill px-3" onclick="exportToExcel()">Excel</button>
                                <button class="btn btn-outline-danger btn-sm rounded-pill px-3" onclick="window.print()">PDF</button>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="bg-light">
                                    <tr>
                                        <th class="border-0 px-4 py-3 small text-muted">DATE</th>
                                        <th class="border-0 px-4 py-3 small text-muted">DESCRIPTION</th>
                                        <th class="border-0 px-4 py-3 small text-muted text-end">DEBIT</th>
                                        <th class="border-0 px-4 py-3 small text-muted text-end">CREDIT</th>
                                    </tr>
                                </thead>
                                <tbody id="statement-table-body"></tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

           
        </main>
    </div>
</div>

<nav class="mobile-nav">
    <a onclick="showPage('dashboard-view')" class="mobile-nav-item active">
        <i class="fas fa-home"></i>
        <span>Home</span>
    </a>
    <a onclick="showPage('transaction-view')" class="mobile-nav-item">
        <i class="fas fa-exchange-alt"></i>
        <span>History</span>
    </a>
    <a onclick="showPage('order-view')" class="mobile-nav-item d-flex flex-column align-items-center">
        <div class="btn-order-circle">
            <i class="fas fa-shopping-cart"></i>
        </div>
        <span style="margin-top: 5px;">Order</span>
    </a>
    <a onclick="showPage('topup-view')" class="mobile-nav-item">
        <i class="fas fa-file-invoice"></i>
        <span>Top Up</span>
    </a>
    <a onclick="showPage('profile-view')" class="mobile-nav-item">
        <i class="fas fa-user"></i>
        <span>Profile</span>
    </a>
</nav>
<script src="../assets/vendors/jquery/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="../assets/vendors/sweetalert/sweetalert.js"></script>
<script src="../assets/vendors/simple-datatables/simple-datatables.js"></script>
<script src="js/ajax.js"></script>
<script src="js/main.js"></script>
</body>
</html>

<?php 
} else {
    header('Location: ../auth-login.html');
    exit;
}

 ?>