<?php
// include your database connection
include 'inc/dbconnt.php'; 

$token = $_GET['token'] ?? '';
$error = '';
$user_data = null;

if (!empty($token)) {
    $date_now = date('Y-m-d H:i:s');
    
    // Check if token is valid, account is inactive, and link hasn't expired
    $stmt = $conn->prepare("SELECT * FROM user_log WHERE invite_token = ? AND is_active = 0 AND token_expiry > ?");
    $stmt->bind_param("ss", $token, $date_now);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $user_data = $result->fetch_assoc();
    } else {
        $error = "This activation link is invalid or has expired. Please contact your administrator.";
    }
} else {
    $error = "No activation token provided.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Account Setup - Logistics Pro</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .setup-card { max-width: 450px; margin: 80px auto; border-radius: 15px; border: none; box-shadow: 0 10px 30px rgba(0,0,0,0.1); }
    </style>
</head>
<body>

<div class="container">
    <div class="card setup-card p-4">
        <div class="text-center mb-4">
            <h3 class="fw-bold text-primary">Finish Your Setup</h3>
            <p class="text-muted small">Please choose a username and a strong password.</p>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php else: ?>
            <form id="setupForm">
                <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                
                <div class="mb-3">
                    <label class="form-label small fw-bold">Email Address</label>
                    <input type="text" class="form-control" value="<?php echo $user_data['email']; ?>" disabled>
                </div>

                <div class="mb-3">
                    <label class="form-label small fw-bold">Choose Username</label>
                    <input type="text" name="username" class="form-control rounded-pill" required placeholder="Enter username">
                </div>

                <div class="mb-4">
                    <label class="form-label small fw-bold">Choose Password</label>
                    <input type="password" name="password" class="form-control rounded-pill" required placeholder="Minimum 8 characters">
                </div>

                <button type="submit" class="btn btn-primary w-100 rounded-pill py-2 shadow-sm">Activate My Account</button>
            </form>
            <div id="responseMsg" class="mt-3"></div>
        <?php endif; ?>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $('#setupForm').on('submit', function(e){
        e.preventDefault();
        $.ajax({
            url: 'inc/code_query.php',
            type: 'POST',
            data: $(this).serialize() + '&action=finalize_setup',
            success: function(res){
                if(res == 1) {
                    $('#responseMsg').html('<div class="alert alert-success">Account activated! Redirecting to login...</div>');
                    setTimeout(function(){ window.location.href = 'auth-login.html'; }, 5000);
                } else {
                    $('#responseMsg').html('<div class="alert alert-danger">' + res + '</div>');
                }
            }
        });
    });
</script>
</body>
</html>